/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import org.jetbrains.annotations.Nullable;

public class NumberToken
extends Token {
    public final double number;
    @Nullable
    public final String formatted;

    public NumberToken(int start, int end, int line, int offset, double number) {
        super(start, end, line, offset, TokenType.NUMBER);
        this.number = number;
        this.formatted = null;
    }

    public NumberToken(int start, int end, int line, int offset, double number, @Nullable String formatted) {
        super(start, end, line, offset, TokenType.NUMBER);
        this.number = number;
        this.formatted = formatted;
    }

    public NumberToken(double number) {
        super(TokenType.NUMBER);
        this.number = number;
        this.formatted = null;
    }

    @Override
    public boolean hasText() {
        return this.formatted != null;
    }

    @Override
    public String parsed() {
        if (this.formatted == null) {
            return super.parsed();
        }
        return this.formatted;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof NumberToken) {
            NumberToken nt = (NumberToken)other;
            return this.number == nt.number && this.spanEquals(nt);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type) + "(start:" + this.start + ",end:" + this.end + ",line:" + this.line + ",lastLine:" + this.lastLine + ",offset:" + this.offset + ",number:'" + this.number + ")";
    }
}

