/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.ParsedToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;

public class StringToken
extends ParsedToken {
    private final StringType stringType;

    public StringToken(int start, int end, int line, int offset, StringType type, String parsed) {
        super(start, end, line, offset, TokenType.STRING, parsed);
        this.stringType = type;
    }

    public StringToken(int start, int end, int line, int lastLine, int offset, StringType type, String parsed) {
        super(start, end, line, lastLine, offset, TokenType.STRING, parsed);
        this.stringType = type;
    }

    public StringToken(StringType type, String parsed) {
        super(TokenType.STRING, parsed);
        this.stringType = type;
    }

    @Override
    public StringType stringType() {
        return this.stringType;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StringToken) {
            StringToken st = (StringToken)other;
            return this.stringType == st.stringType && this.parsed.equals(st.parsed) && this.spanEquals(st);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type) + "(start:" + this.start + ",end:" + this.end + ",line:" + this.line + ",lastLine:" + this.lastLine + ",offset:" + this.offset + ",stringType:'" + String.valueOf((Object)this.stringType) + ",parsed:'" + this.parsed + "')";
    }
}

