/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization;

import org.jetbrains.annotations.NotNull;

public class Span<T>
implements Comparable<Span<?>> {
    protected int start;
    protected int end;
    protected int line;
    protected int lastLine;
    protected int offset;
    protected T type;

    public Span(int start, int end, int line, int offset, T type) {
        this(start, end, line, line, offset, type);
    }

    public Span(int start, int end, int line, int lastLine, int offset, T type) {
        this.start = start;
        this.end = end;
        this.line = line;
        this.lastLine = lastLine;
        this.offset = offset;
        this.type = type;
    }

    protected Span(T type) {
        this.type = type;
    }

    public final String textOf(CharSequence reference) {
        return reference.subSequence(this.start, this.end).toString();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int line() {
        return this.line;
    }

    public int lastLine() {
        return this.lastLine;
    }

    public int offset() {
        return this.offset;
    }

    public T type() {
        return this.type;
    }

    public int length() {
        return this.end - this.start;
    }

    public int lines() {
        return this.lastLine - this.line;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Span) {
            return this.spanEquals((Span)other);
        }
        return false;
    }

    public boolean spanEquals(Span<?> other) {
        return this.start == other.start && this.end == other.end && this.line == other.line && this.lastLine == other.lastLine && this.offset == other.offset && this.type == other.type;
    }

    public String toString() {
        return String.valueOf(this.type) + "(start:" + this.start + ",end:" + this.end + ",line:" + this.line + ",lastLine:" + this.lastLine + ",offset:" + this.offset + ")";
    }

    @Override
    public int compareTo(@NotNull Span<?> o) {
        int s = Integer.compare(this.start, o.start);
        if (s != 0) {
            return s;
        }
        return Integer.compare(this.end, o.end);
    }
}

