/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.entity.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_9346;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfVariantBiomeRegistry {
    private static final Map<class_5321<class_1959>, List<class_5321<class_9346>>> WOLF_VARIANT_FROM_BIOME = new Object2ObjectOpenHashMap();

    public static void register(@NotNull class_5321<class_1959> biome, @NotNull class_5321<class_9346> wolfVariant) {
        ArrayList<class_5321<class_9346>> variantList = WOLF_VARIANT_FROM_BIOME.getOrDefault(biome, null);
        if (variantList == null) {
            variantList = new ArrayList<class_5321<class_9346>>();
            WOLF_VARIANT_FROM_BIOME.put(biome, variantList);
        }
        variantList.add(wolfVariant);
    }

    @NotNull
    public static Optional<class_5321<class_9346>> get(class_5321<class_1959> biome) {
        return Optional.ofNullable(WolfVariantBiomeRegistry.getVariantOrNull(biome));
    }

    @NotNull
    public static Optional<class_9346> get(@NotNull class_5455 registryManager, class_5321<class_1959> biome) {
        class_2378 registry = registryManager.method_30530(class_7924.field_49772);
        return registry.method_31189(WolfVariantBiomeRegistry.getVariantOrNull(biome));
    }

    @Nullable
    private static class_5321<class_9346> getVariantOrNull(class_5321<class_1959> biome) {
        List variantList = WOLF_VARIANT_FROM_BIOME.getOrDefault(biome, null);
        if (variantList != null && !variantList.isEmpty()) {
            int size = variantList.size();
            return (class_5321)variantList.get(AdvancedMath.random().method_43048(size));
        }
        return null;
    }
}

