/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.entity.api.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.frozenblock.lib.entity.impl.behavior.FrozenLibBehavior;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public abstract class MoveToBlockBehavior<E extends class_1314>
extends class_4097<E> {
    public static final int DURATION = 1200;
    public final double speedModifier;
    protected final E mob;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int tryTicks;
    protected class_2338 blockPos = class_2338.field_10980;
    protected int verticalSearchStart;
    private boolean reachedTarget;

    public MoveToBlockBehavior(E mob, double speedModifier, int searchRange) {
        this(mob, speedModifier, searchRange, 1);
    }

    public MoveToBlockBehavior(E mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((Map)ImmutableMap.of(), 1200);
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = verticalSearchRange;
    }

    public boolean checkExtraStartConditions(@NotNull class_3218 level, @NotNull E owner) {
        return this.findNearestBlock();
    }

    public boolean canStillUse(@NotNull class_3218 level, @NotNull E entity, long gameTime) {
        return this.tryTicks >= -((FrozenLibBehavior)((Object)this)).frozenLib$getDuration() && this.tryTicks <= 1200 && this.isValidTarget((class_4538)level, this.blockPos);
    }

    public void start(@NotNull class_3218 level, @NotNull E entity, long gameTime) {
        this.moveMobToBlock();
        this.tryTicks = 0;
    }

    protected void moveMobToBlock() {
        this.mob.method_5942().method_6337((double)this.blockPos.method_10263() + 0.5, (double)this.blockPos.method_10264() + 1.0, (double)this.blockPos.method_10260() + 0.5, this.speedModifier);
    }

    public double acceptedDistance() {
        return 1.0;
    }

    protected class_2338 getMoveToTarget() {
        return this.blockPos.method_10084();
    }

    protected void tick(@NotNull class_3218 level, @NotNull E owner, long gameTime) {
        class_2338 blockPos = this.getMoveToTarget();
        if (!blockPos.method_19769((class_2374)owner.method_73189(), this.acceptedDistance())) {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.mob.method_5942().method_6337((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, this.speedModifier);
            }
        } else {
            this.reachedTarget = true;
            --this.tryTicks;
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    protected boolean isReachedTarget() {
        return this.reachedTarget;
    }

    protected boolean findNearestBlock() {
        class_2338 blockPos = this.mob.method_24515();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int k = this.verticalSearchStart;
        while (k <= this.verticalSearchRange) {
            for (int l = 0; l < this.searchRange; ++l) {
                int m = 0;
                while (m <= l) {
                    int n;
                    int n2 = n = m < l && m > -l ? l : 0;
                    while (n <= l) {
                        mutableBlockPos.method_25504((class_2382)blockPos, m, k - 1, n);
                        if (this.mob.method_18407((class_2338)mutableBlockPos) && this.isValidTarget((class_4538)this.mob.method_73183(), (class_2338)mutableBlockPos)) {
                            this.blockPos = mutableBlockPos;
                            return true;
                        }
                        n = n > 0 ? -n : 1 - n;
                    }
                    m = m > 0 ? -m : 1 - m;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    public abstract boolean isValidTarget(class_4538 var1, class_2338 var2);
}

