/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.gravity.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.Event;
import net.frozenblock.lib.entrypoint.api.CommonEventEntrypoint;
import net.frozenblock.lib.event.api.FrozenEvents;
import net.frozenblock.lib.gravity.api.GravityBelt;
import net.frozenblock.lib.gravity.api.GravityContext;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public final class GravityAPI {
    public static final class_243 DEFAULT_GRAVITY = new class_243(0.0, 1.0, 0.0);
    public static final Event<GravityModification> MODIFICATIONS = FrozenEvents.createEnvironmentEvent(GravityModification.class, callbacks -> context -> {
        for (GravityModification callback : callbacks) {
            callback.modifyGravity(context);
        }
    });
    private static final Map<class_5321<class_1937>, List<GravityBelt<?>>> GRAVITY_BELTS = new HashMap();

    public static void register(class_5321<class_1937> dimension, GravityBelt<?> gravityBelt) {
        GravityAPI.getAllBelts(dimension).add(gravityBelt);
    }

    @NotNull
    public static List<GravityBelt<?>> getAllBelts(class_5321<class_1937> dimension) {
        return GRAVITY_BELTS.computeIfAbsent(dimension, dimension1 -> new ArrayList());
    }

    public static List<GravityBelt<?>> getAllBelts(class_1937 level) {
        return GravityAPI.getAllBelts((class_5321<class_1937>)level.method_27983());
    }

    public static class_243 calculateGravity(class_5321<class_1937> dimension, double y) {
        GravityContext context = new GravityContext(dimension, y, null, null);
        ((GravityModification)MODIFICATIONS.invoker()).modifyGravity(context);
        return context.gravity;
    }

    public static class_243 calculateGravity(class_1937 level, double y) {
        return GravityAPI.calculateGravity((class_5321<class_1937>)level.method_27983(), y);
    }

    public static class_243 calculateGravity(class_1297 entity) {
        class_5321 dimension = entity.method_73183().method_27983();
        GravityContext context = new GravityContext((class_5321<class_1937>)dimension, entity.method_23318(), entity, entity.method_55667());
        ((GravityModification)MODIFICATIONS.invoker()).modifyGravity(context);
        return context.gravity;
    }

    public static List<GravityBelt<?>> getAffectingGravityBelts(List<GravityBelt<?>> belts, double y) {
        ArrayList gravityBelts = new ArrayList();
        for (GravityBelt<?> belt : belts) {
            if (!belt.affectsPosition(y)) continue;
            gravityBelts.add(belt);
        }
        return gravityBelts;
    }

    static {
        MODIFICATIONS.register(context -> {
            if (!GRAVITY_BELTS.containsKey(context.dimension)) {
                return;
            }
            for (GravityBelt<?> belt : GravityAPI.getAffectingGravityBelts(GRAVITY_BELTS.get(context.dimension), context.y)) {
                context.gravity = belt.getGravity(null, context.y);
            }
        });
    }

    @FunctionalInterface
    public static interface GravityModification
    extends CommonEventEntrypoint {
        public void modifyGravity(GravityContext var1);
    }
}

