/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.serialization.Span;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.ParsedToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;

public class Token
extends Span<TokenType> {
    public Token(int start, int end, int line, int offset, TokenType type) {
        super(start, end, line, offset, type);
    }

    public Token(int start, int end, int line, int lastLine, int offset, TokenType type) {
        super(start, end, line, lastLine, offset, type);
    }

    protected Token(TokenType type) {
        super(type);
    }

    public boolean hasText() {
        return false;
    }

    public String parsed(CharSequence reference) {
        return this.textOf(reference);
    }

    public String parsed() {
        throw new UnsupportedOperationException("not parsed");
    }

    public ParsedToken intoParsed(CharSequence reference) {
        if (this instanceof ParsedToken) {
            return (ParsedToken)this;
        }
        return new ParsedToken(this.start, this.end, this.line, this.lastLine, this.offset, (TokenType)((Object)this.type), this.parsed(reference));
    }

    public boolean isSymbol(char symbol) {
        return false;
    }

    public boolean isText(CharSequence reference, String text) {
        return reference.toString().regionMatches(this.start, text, 0, this.length());
    }

    public boolean isText(String text) {
        throw new UnsupportedOperationException("not parsed");
    }

    public StringType stringType() {
        return StringType.NONE;
    }

    public CommentStyle commentStyle() {
        throw new UnsupportedOperationException("not a comment");
    }

    public boolean isMetadata() {
        return this.type == TokenType.BREAK || this.type == TokenType.COMMENT;
    }

    protected void setStart(int start) {
        this.start = start;
    }

    protected void setEnd(int end) {
        this.end = end;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    protected void setLine(int line) {
        this.line = line;
    }

    protected void setLastLine(int lastLine) {
        this.lastLine = lastLine;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Token) {
            return this.spanEquals((Token)other);
        }
        return false;
    }
}

