/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.spotting_icons.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.spotting_icons.api.SpottingIconPredicate;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconRemovePacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SpottingIconManager {
    public class_1297 entity;
    public int ticksToCheck;
    public SpottingIcon icon;
    public boolean clientHasIconResource;

    public SpottingIconManager(class_1297 entity) {
        this.entity = entity;
    }

    public void tick() {
        if (this.ticksToCheck > 0) {
            --this.ticksToCheck;
        } else {
            this.ticksToCheck = 20;
            if (this.icon != null) {
                if (this.entity.method_73183().method_8608()) {
                    this.clientHasIconResource = SpottingIconManager.hasTexture(this.icon.texture());
                }
                if (!SpottingIconPredicate.getPredicate(this.icon.restrictionID).test(this.entity)) {
                    this.removeIcon();
                }
            }
        }
    }

    public void setIcon(class_2960 texture, float startFade, float endFade, class_2960 restrictionID) {
        this.icon = new SpottingIcon(texture, startFade, endFade, restrictionID);
        if (!this.entity.method_73183().method_8608()) {
            SpottingIconPacket packet = new SpottingIconPacket(this.entity.method_5628(), texture, startFade, endFade, restrictionID);
            for (class_3222 player : PlayerLookup.tracking((class_1297)this.entity)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
        } else {
            this.clientHasIconResource = SpottingIconManager.hasTexture(this.icon.texture());
        }
        SpottingIconPredicate.getPredicate(this.icon.restrictionID).onAdded(this.entity);
    }

    public void removeIcon() {
        SpottingIconPredicate.getPredicate(this.icon.restrictionID).onRemoved(this.entity);
        this.icon = null;
        if (!this.entity.method_73183().method_8608()) {
            SpottingIconRemovePacket packet = new SpottingIconRemovePacket(this.entity.method_5628());
            for (class_3222 player : PlayerLookup.tracking((class_1297)this.entity)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
        }
    }

    public void sendIconPacket(class_3222 player) {
        if (this.icon != null) {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.method_10804(this.entity.method_5628());
            byteBuf.method_10812(this.icon.texture);
            byteBuf.method_52941(this.icon.startFadeDist);
            byteBuf.method_52941(this.icon.endFadeDist);
            byteBuf.method_10812(this.icon.restrictionID);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SpottingIconPacket(this.entity.method_5628(), this.icon.texture, this.icon.startFadeDist(), this.icon.endFadeDist(), this.icon.restrictionID()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static boolean hasTexture(class_2960 resourceLocation) {
        return class_310.method_1551().method_1478().method_14486(resourceLocation).isPresent();
    }

    public void load(@NotNull class_11368 input) {
        this.ticksToCheck = input.method_71424("frozenlib_spotting_icon_predicate_cooldown", 0);
        this.icon = null;
        Optional icon = input.method_71426("frozenlib_spotting_icons", SpottingIcon.CODEC);
        icon.ifPresent(spottingIcon -> {
            this.icon = spottingIcon;
        });
    }

    public void save(@NotNull class_11372 output) {
        output.method_71465("frozenlib_spotting_icon_predicate_cooldown", this.ticksToCheck);
        if (this.icon != null) {
            output.method_71468("frozenlib_spotting_icons", SpottingIcon.CODEC, (Object)this.icon);
        } else {
            output.method_71478("frozenlib_spotting_icons");
        }
    }

    public record SpottingIcon(class_2960 texture, float startFadeDist, float endFadeDist, class_2960 restrictionID) {
        public static final Codec<SpottingIcon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(SpottingIcon::texture), (App)Codec.FLOAT.fieldOf("startFadeDist").forGetter(SpottingIcon::startFadeDist), (App)Codec.FLOAT.fieldOf("endFadeDist").forGetter(SpottingIcon::endFadeDist), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(SpottingIcon::restrictionID)).apply((Applicative)instance, SpottingIcon::new));
    }
}

