/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.texture.client.api;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.texture.client.api.ServerTextureDownloader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1061;

@Environment(value=EnvType.CLIENT)
public class ServerTexture
extends class_1043
implements class_1061 {
    private final String destPath;
    private final String fileName;
    private boolean closed;
    private final long timeInMilisBeforeClose;
    private long timeSinceLastReference;

    public ServerTexture(class_1011 nativeImage, String destPath, String fileName) {
        super(() -> fileName, nativeImage);
        this.timeInMilisBeforeClose = 5000L;
        this.destPath = destPath;
        this.fileName = fileName;
    }

    public ServerTexture(class_1011 nativeImage, long timeInMilisBeforeClose, String destPath, String fileName) {
        super(() -> fileName, nativeImage);
        this.timeInMilisBeforeClose = timeInMilisBeforeClose;
        this.destPath = destPath;
        this.fileName = fileName;
    }

    public void updateReferenceTime() {
        this.timeSinceLastReference = System.currentTimeMillis();
        if (this.closed) {
            this.closed = false;
            try {
                this.method_4526(ServerTextureDownloader.downloadServerTexture(null, this.destPath, this.fileName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void method_4622() {
        if (!this.closed && System.currentTimeMillis() - this.timeSinceLastReference > this.timeInMilisBeforeClose) {
            class_1011 nativeImage = this.method_4525();
            if (nativeImage != null) {
                nativeImage.close();
            }
            this.closed = true;
        }
    }
}

