/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.structure.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.fabricmc.fabric.api.event.Event;
import net.frozenblock.lib.entrypoint.api.CommonEventEntrypoint;
import net.frozenblock.lib.event.api.FrozenEvents;
import net.frozenblock.lib.worldgen.structure.impl.StructureTemplatePoolInterface;
import net.minecraft.class_2960;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.qsl.frozenblock.core.registry.api.event.RegistryEvents;

public final class TemplatePoolApi {
    public static final Event<AddAdditionalTemplatePools> ADD_ADDITIONAL_TEMPLATE_POOLS = FrozenEvents.createEnvironmentEvent(AddAdditionalTemplatePools.class, callbacks -> (registry, context) -> {
        for (AddAdditionalTemplatePools callback : callbacks) {
            callback.addAdditionalTemplatePools((class_7225.class_7226<class_5497>)registry, context);
        }
    });

    public static void init() {
        RegistryEvents.DYNAMIC_REGISTRY_LOADED.register(registryAccess -> {
            TemplatePoolAdditionHolder context = new TemplatePoolAdditionHolder();
            registryAccess.method_46759(class_7924.field_41247).ifPresent(processorListRegistry -> ((AddAdditionalTemplatePools)ADD_ADDITIONAL_TEMPLATE_POOLS.invoker()).addAdditionalTemplatePools((class_7225.class_7226<class_5497>)processorListRegistry, context));
            registryAccess.method_46759(class_7924.field_41249).ifPresent(templatePoolRegistry -> templatePoolRegistry.method_29722().forEach(templatePoolEntry -> {
                Object patt0$temp = templatePoolEntry.getValue();
                if (patt0$temp instanceof StructureTemplatePoolInterface) {
                    StructureTemplatePoolInterface templatePoolInterface = (StructureTemplatePoolInterface)patt0$temp;
                    List<Pair<class_3784, Integer>> additionalElements = context.getAdditionalElements(((class_5321)templatePoolEntry.getKey()).method_29177());
                    if (!additionalElements.isEmpty()) {
                        templatePoolInterface.frozenlib$addTemplatePools(additionalElements);
                    }
                }
            }));
        });
    }

    @Generated
    private TemplatePoolApi() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TemplatePoolAdditionHolder {
        protected final Map<class_2960, List<Pair<class_3784, Integer>>> poolToElements = new Object2ObjectOpenHashMap();

        public void addElement(class_2960 pool, @NotNull Function<class_3785.class_3786, ? extends class_3784> elementFunction, int weight, class_3785.class_3786 projection) {
            class_3784 element = elementFunction.apply(projection);
            List list = this.poolToElements.getOrDefault(pool, new ArrayList());
            list.add(Pair.of((Object)element, (Object)weight));
            this.poolToElements.put(pool, list);
        }

        @NotNull
        public List<Pair<class_3784, Integer>> getAdditionalElements(class_2960 pool) {
            return new ArrayList<Pair<class_3784, Integer>>((Collection)this.poolToElements.getOrDefault(pool, (List<Pair<class_3784, Integer>>)ImmutableList.of()));
        }
    }

    @FunctionalInterface
    public static interface AddAdditionalTemplatePools
    extends CommonEventEntrypoint {
        public void addAdditionalTemplatePools(class_7225.class_7226<class_5497> var1, TemplatePoolAdditionHolder var2);
    }
}

