/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.impl.event;

import java.util.function.Predicate;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.qsl.frozenblock.core.registry.api.event.RegistryEntryContext;
import org.quiltmc.qsl.frozenblock.core.registry.api.event.RegistryEvents;
import org.quiltmc.qsl.frozenblock.core.registry.api.event.RegistryMonitor;
import org.quiltmc.qsl.frozenblock.core.registry.impl.event.DelayedRegistry;
import org.quiltmc.qsl.frozenblock.core.registry.impl.event.MutableRegistryEntryContextImpl;

@ApiStatus.Internal
public class RegistryMonitorImpl<V>
implements RegistryMonitor<V> {
    private final class_2378<V> registry;
    @Nullable
    private Predicate<RegistryEntryContext<V>> filter = null;

    public RegistryMonitorImpl(class_2378<V> registry) {
        this.registry = registry;
    }

    @Override
    public RegistryMonitor<V> filter(Predicate<RegistryEntryContext<V>> filter) {
        this.filter = this.filter == null ? filter : this.filter.and(filter);
        return this;
    }

    @Override
    public void forAll(RegistryEvents.EntryAdded<V> callback) {
        if (!(this.registry instanceof class_2385)) {
            throw new UnsupportedOperationException("Registry " + String.valueOf(this.registry) + " is not supported!");
        }
        DelayedRegistry delayed = new DelayedRegistry((class_2370)this.registry);
        MutableRegistryEntryContextImpl context = new MutableRegistryEntryContextImpl(delayed);
        this.registry.method_42017().forEach(entry -> {
            context.set(((class_5321)entry.method_40230().orElseThrow()).method_29177(), entry.comp_349());
            if (this.testFilter(context)) {
                callback.onAdded(context);
            }
        });
        this.forUpcoming(callback);
        delayed.applyDelayed();
    }

    @Override
    public void forUpcoming(RegistryEvents.EntryAdded<V> callback) {
        RegistryEvents.getEntryAddEvent(this.registry).register(context -> {
            if (this.testFilter(context)) {
                callback.onAdded(context);
            }
        });
    }

    private boolean testFilter(RegistryEntryContext<V> context) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.test(context);
    }
}

