/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8710;
import net.minecraft.class_8828;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocol;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocolDef;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ClientPackets;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ProtocolVersions;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.RegistrySyncText;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ServerPackets;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client.LogBuilder;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.server.ServerRegistrySync;
import org.slf4j.Logger;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class ClientRegistrySync {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int syncVersion = -1;
    private static int currentCount;
    private static byte currentFlags;
    private static class_2561 errorStyleHeader;
    private static class_2561 errorStyleFooter;
    private static boolean showErrorDetails;
    private static class_2561 disconnectMainReason;
    private static final LogBuilder builder;
    private static boolean mustDisconnect;

    public static void registerHandlers() {
        ClientConfigurationNetworking.registerGlobalReceiver(ServerPackets.Handshake.PACKET_TYPE, ClientRegistrySync::handleHelloPacket);
        ClientConfigurationNetworking.registerGlobalReceiver(ServerPackets.End.PACKET_TYPE, ClientRegistrySync::handleEndPacket);
        ClientConfigurationNetworking.registerGlobalReceiver(ServerPackets.ErrorStyle.PACKET_TYPE, ClientRegistrySync::handleErrorStylePacket);
        ClientConfigurationNetworking.registerGlobalReceiver(ServerPackets.ModProtocol.PACKET_TYPE, ClientRegistrySync::handleModProtocol);
    }

    private static void handleModProtocol(ServerPackets.ModProtocol modProtocol, ClientConfigurationNetworking.Context ctx) {
        String prioritizedId = modProtocol.prioritizedId();
        Collection<ModProtocolDef> protocols = modProtocol.protocols();
        Object2IntOpenHashMap values = new Object2IntOpenHashMap(protocols.size());
        ArrayList<ModProtocolDef> unsupportedList = new ArrayList<ModProtocolDef>();
        ModProtocolDef missingPrioritized = null;
        boolean disconnect = false;
        for (ModProtocolDef protocol : protocols) {
            IntList local = ModProtocol.getVersion(protocol.id());
            int latest = protocol.latestMatchingVersion((IntCollection)local);
            LOGGER.info(String.valueOf(latest));
            if (latest != -1) {
                values.put((Object)protocol.id(), latest);
                continue;
            }
            if (protocol.optional()) continue;
            unsupportedList.add(protocol);
            disconnect = true;
            if (!prioritizedId.equals(protocol.id())) continue;
            missingPrioritized = protocol;
        }
        if (disconnect) {
            ClientRegistrySync.markDisconnected(RegistrySyncText.unsupportedModVersion(unsupportedList, missingPrioritized));
            builder.pushT("unsupported_protocol", "Unsupported Mod Protocol", new Object[0]);
            for (ModProtocolDef entry : unsupportedList) {
                builder.textEntry((class_2561)class_2561.method_43470((String)entry.displayName()).method_10852((class_2561)class_2561.method_43470((String)(" (" + entry.id() + ")")).method_27692(class_124.field_1063)).method_27693(" | Server: ").method_27693(ClientRegistrySync.stringifyVersions(entry.versions())).method_27693(", Client: ").method_27693(ClientRegistrySync.stringifyVersions(ModProtocol.getVersion(entry.id()))));
            }
        } else {
            ClientRegistrySync.sendSupportedModProtocol(ctx.responseSender(), (Object2IntOpenHashMap<String>)values);
        }
    }

    private static void handleEndPacket(ServerPackets.End end, ClientConfigurationNetworking.Context ctx) {
        syncVersion = -1;
        if (mustDisconnect) {
            class_5250 entry = class_2561.method_43473();
            entry.method_10852(errorStyleHeader);
            if (disconnectMainReason != null && showErrorDetails && !ClientRegistrySync.isTextEmpty(disconnectMainReason)) {
                entry.method_27693("\n");
                entry.method_10852(disconnectMainReason);
            }
            if (!ClientRegistrySync.isTextEmpty(errorStyleFooter)) {
                entry.method_27693("\n");
                entry.method_10852(errorStyleFooter);
            }
            ctx.responseSender().disconnect((class_2561)entry);
            LOGGER.warn(builder.asString());
        } else {
            ctx.responseSender().sendPacket((class_8710)new ClientPackets.End());
        }
    }

    private static String stringifyVersions(IntList versions) {
        if (versions == null || versions.isEmpty()) {
            return "Missing!";
        }
        StringBuilder b = new StringBuilder().append('[');
        IntListIterator iter = versions.iterator();
        while (iter.hasNext()) {
            b.append(iter.nextInt());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        return b.append(']').toString();
    }

    private static void sendSupportedModProtocol(PacketSender sender, Object2IntOpenHashMap<String> values) {
        sender.sendPacket((class_8710)new ClientPackets.ModProtocol(values));
    }

    private static void handleErrorStylePacket(ServerPackets.ErrorStyle errorStyle, ClientConfigurationNetworking.Context ctx) {
        errorStyleHeader = errorStyle.errorHeader();
        errorStyleFooter = errorStyle.errorFooter();
        showErrorDetails = errorStyle.showError();
    }

    private static void handleHelloPacket(ServerPackets.Handshake handshake, ClientConfigurationNetworking.Context ctx) {
        syncVersion = ProtocolVersions.getHighestSupportedLocal(handshake.supportedVersions());
        ctx.responseSender().sendPacket((class_8710)new ClientPackets.Handshake(syncVersion));
        builder.clear();
    }

    private static void markDisconnected(class_2561 reason) {
        if (disconnectMainReason == null) {
            disconnectMainReason = reason;
        }
        mustDisconnect = true;
    }

    private static boolean isTextEmpty(class_2561 text) {
        class_8828 literalContents;
        class_7417 class_74172;
        return (text.method_10851().equals((Object)class_8828.field_46625) || (class_74172 = text.method_10851()) instanceof class_8828 && (literalContents = (class_8828)class_74172).comp_737().isEmpty()) && text.method_10855().isEmpty();
    }

    public static void disconnectCleanup(class_310 client) {
        errorStyleHeader = ServerRegistrySync.errorStyleHeader;
        errorStyleFooter = ServerRegistrySync.errorStyleFooter;
        showErrorDetails = ServerRegistrySync.showErrorDetails;
        disconnectMainReason = null;
    }

    static {
        errorStyleHeader = ServerRegistrySync.errorStyleHeader;
        errorStyleFooter = ServerRegistrySync.errorStyleFooter;
        showErrorDetails = ServerRegistrySync.showErrorDetails;
        disconnectMainReason = null;
        builder = new LogBuilder();
    }
}

