/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.file.transfer.client;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.file.transfer.FileTransferPacket;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_1061;
import net.minecraft.class_156;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ServerTexture
extends class_1049
implements class_1061 {
    public static final Map<String, ServerTexture> WAITING_TEXTURES = new HashMap<String, ServerTexture>();
    public static final String LOCAL_TEXTURE_SOURCE = ".local";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File file;
    private final String destPath;
    private final String fileName;
    @Nullable
    private final Runnable onDownloaded;
    boolean hasLocalSource;
    @Nullable
    private CompletableFuture<?> future;
    private boolean uploaded;
    private long timeSinceLastReference;
    private boolean isClosed;

    public ServerTexture(String destPath, String fileName, class_2960 fallback, @Nullable Runnable callback) {
        super(fallback);
        Path path = class_310.method_1551().field_1697.toPath().resolve(destPath);
        File possibleLocalFile = path.resolve(LOCAL_TEXTURE_SOURCE).resolve(fileName).toFile();
        this.hasLocalSource = possibleLocalFile.exists();
        this.file = this.hasLocalSource ? possibleLocalFile : path.resolve(fileName).toFile();
        this.destPath = destPath;
        this.fileName = fileName;
        this.onDownloaded = callback;
        this.timeSinceLastReference = System.currentTimeMillis();
        if (!this.hasLocalSource) {
            WAITING_TEXTURES.put(this.destPath + "/" + this.fileName, this);
        }
    }

    private void loadCallback(class_1011 image) {
        if (this.onDownloaded != null) {
            this.onDownloaded.run();
        }
        class_310.method_1551().execute(() -> {
            this.uploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            } else {
                this.upload(image);
            }
        });
    }

    private void upload(@NotNull class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
        image.method_4301(0, 0, 0, true);
    }

    public void runFutureForTexture() {
        if (this.future == null) {
            this.future = CompletableFuture.runAsync(() -> {
                LOGGER.debug("Downloading server texture {}", (Object)this.fileName);
                try {
                    FileInputStream inputStream = new FileInputStream(this.file);
                    class_310.method_1551().execute(() -> {
                        class_1011 nativeImagex = this.load(inputStream);
                        if (nativeImagex != null) {
                            this.loadCallback(nativeImagex);
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't download server texture", (Throwable)e);
                }
            }, (Executor)class_156.method_18349());
        }
    }

    public void method_4625(class_3300 manager) throws IOException {
        class_1011 nativeImage;
        class_310.method_1551().execute(() -> {
            if (!this.uploaded) {
                try {
                    super.method_4625(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load server texture: {}", (Object)this.field_5224, (Object)var3x);
                }
                this.uploaded = true;
            }
        });
        if (this.file != null && this.file.exists() && this.file.isFile()) {
            LOGGER.debug("Loading server texture from local cache ({})", (Object)this.file);
            FileInputStream fileInputStream = new FileInputStream(this.file);
            nativeImage = this.load(fileInputStream);
            fileInputStream.close();
        } else {
            if (FrozenLibConfig.FILE_TRANSFER_CLIENT) {
                class_310.method_1551().method_1562().method_52787((class_2596)new class_2817((class_8710)FileTransferPacket.createRequest(this.destPath, this.fileName)));
            }
            nativeImage = null;
        }
        if (nativeImage != null) {
            this.loadCallback(nativeImage);
        }
    }

    @Nullable
    private class_1011 load(InputStream stream) {
        class_1011 nativeImage = null;
        try {
            nativeImage = class_1011.method_4309((InputStream)stream);
        }
        catch (Exception e) {
            LOGGER.warn("Error while loading server texture", (Throwable)e);
        }
        return nativeImage;
    }

    public void updateReferenceTime() {
        this.timeSinceLastReference = System.currentTimeMillis();
        if (this.isClosed) {
            this.isClosed = false;
            try {
                this.method_4625(class_310.method_1551().method_1478());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void method_4622() {
        if (!this.isClosed && System.currentTimeMillis() - this.timeSinceLastReference > 5000L) {
            this.method_18153(class_310.method_1551().method_1478()).close();
            this.isClosed = true;
        }
    }
}

