/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.exception;

public class SyntaxException
extends RuntimeException {
    private final int line;
    private final int column;

    public SyntaxException(String msg, int line, int column) {
        super(msg + " at " + line + ":" + column);
        this.line = line;
        this.column = column;
    }

    public static SyntaxException illegalToken(String text, int line, int column) {
        return new SyntaxException("Illegal token: '" + text + "'", line, column);
    }

    public static SyntaxException expected(char expected, int line, int column) {
        return new SyntaxException("Expected '" + expected + "'", line, column);
    }

    public static SyntaxException expected(String expected, int line, int column) {
        return new SyntaxException("Expected " + expected, line, column);
    }

    public static SyntaxException unexpected(char unexpected, int line, int column) {
        return new SyntaxException("Unexpected '" + unexpected + "'", line, column);
    }

    public static SyntaxException unexpected(String unexpected, int line, int column) {
        return new SyntaxException("Unexpected " + unexpected, line, column);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

