/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;

public class SymbolToken
extends Token {
    public final char symbol;

    public SymbolToken(int start, int end, int line, int offset, char symbol) {
        this(start, end, line, offset, TokenType.SYMBOL, symbol);
    }

    public SymbolToken(int start, int end, int line, int offset, TokenType type, char symbol) {
        super(start, end, line, offset, type);
        this.symbol = symbol;
    }

    public SymbolToken(char symbol) {
        super(symbol == '\n' ? TokenType.BREAK : TokenType.SYMBOL);
        this.symbol = symbol;
    }

    @Override
    public boolean isSymbol(char symbol) {
        return this.symbol == symbol;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SymbolToken) {
            SymbolToken st = (SymbolToken)other;
            return this.symbol == st.symbol && this.spanEquals(st);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type) + "(start:" + this.start + ",end:" + this.end + ",line:" + this.line + ",lastLine:" + this.lastLine + ",offset:" + this.offset + ",symbol:" + this.symbol + ")";
    }
}

