/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.surface.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6686;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptimizedBiomeTagConditionSource
implements class_6686.class_6693 {
    public static final class_7243<OptimizedBiomeTagConditionSource> CODEC = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41236).fieldOf("biome_tag").forGetter(OptimizedBiomeTagConditionSource::getBiomeTagKey)).apply((Applicative)instance, OptimizedBiomeTagConditionSource::new)));
    public final class_6862<class_1959> biomeTagKey;
    @Nullable
    public List<class_5321<class_1959>> biomes;
    @Nullable
    public Predicate<class_5321<class_1959>> biomeNameTest;
    public static final List<OptimizedBiomeTagConditionSource> INSTANCES = new ArrayList<OptimizedBiomeTagConditionSource>();

    public static void optimizeAll(@NotNull class_2378<class_1959> biomeRegistry) {
        INSTANCES.forEach(optimizedBiomeTagConditionSource -> optimizedBiomeTagConditionSource.optimize(biomeRegistry));
    }

    public void optimize(@NotNull class_2378<class_1959> biomeRegistry) {
        this.biomes = null;
        this.biomeNameTest = null;
        ArrayList biomeList = new ArrayList();
        biomeRegistry.method_46733(this.biomeTagKey).ifPresent(biomes -> {
            for (class_6880 biomeHolder : biomes) {
                biomeHolder.method_40230().ifPresent(biomeList::add);
            }
            this.biomes = biomeList;
        });
        if (this.biomes != null) {
            this.biomeNameTest = Set.copyOf(this.biomes)::contains;
            FrozenLibLogUtils.log("OPTIMIZED A SOURCE :D", FrozenLibConstants.UNSTABLE_LOGGING);
        } else {
            FrozenLibLogUtils.log("COULDN'T OPTIMIZE A SOURCE :(", FrozenLibConstants.UNSTABLE_LOGGING);
        }
    }

    public OptimizedBiomeTagConditionSource(class_6862<class_1959> biomeTagKey) {
        this.biomeTagKey = biomeTagKey;
        INSTANCES.add(this);
    }

    @NotNull
    public class_7243<? extends class_6686.class_6693> method_39064() {
        return CODEC;
    }

    @NotNull
    public class_6686.class_6692 apply(@NotNull class_6686.class_6694 context) {
        class BiomeTagCondition
        extends class_6686.class_6774 {
            BiomeTagCondition(class_6686.class_6694 context) {
                super(context);
            }

            protected boolean method_39074() {
                if (OptimizedBiomeTagConditionSource.this.biomeNameTest != null) {
                    return ((class_6880)this.field_35623.field_35614.get()).method_40224(OptimizedBiomeTagConditionSource.this.biomeNameTest);
                }
                return ((class_6880)this.field_35623.field_35614.get()).method_40220(OptimizedBiomeTagConditionSource.this.biomeTagKey);
            }
        }
        return new BiomeTagCondition(context);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OptimizedBiomeTagConditionSource) {
            OptimizedBiomeTagConditionSource biomeConditionSource = (OptimizedBiomeTagConditionSource)object;
            return this.biomeTagKey.equals(biomeConditionSource.biomeTagKey);
        }
        return false;
    }

    public int hashCode() {
        return this.biomeTagKey.hashCode();
    }

    @NotNull
    public String toString() {
        return "BiomeConditionSource[biomeTagKey=" + String.valueOf(this.biomeTagKey) + ", optimized]";
    }

    private static class_6862<class_1959> getBiomeTagKey(@NotNull Object o) {
        return ((OptimizedBiomeTagConditionSource)o).biomeTagKey;
    }
}

