/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import net.frozenblock.lib.config.api.instance.xjs.InvalidEnumConstantException;
import net.frozenblock.lib.config.api.instance.xjs.JsonFormatException;
import net.frozenblock.lib.config.api.instance.xjs.JsonPath;
import net.frozenblock.lib.config.api.instance.xjs.UnreachableException;
import net.frozenblock.lib.config.api.instance.xjs.XjsOps;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.personthecat.fresult.Void;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonLiteral;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XjsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XjsUtils.class);

    public static Optional<JsonObject> readJson(File file) {
        return Result.define(FileNotFoundException.class, Result::WARN).define(SyntaxException.class, e -> {
            throw new JsonFormatException(InvalidEnumConstantException.f(file.getPath(), e));
        }).suppress(() -> Json.parse(file).asObject()).get();
    }

    public static Optional<JsonObject> readJson(InputStream is) {
        return Result.define(IOException.class, Result::WARN).define(SyntaxException.class, r -> {
            throw new JsonFormatException("Reading data");
        }).suppress(() -> Json.parse(is).asObject()).get();
    }

    public static Optional<JsonObject> readSuppressing(File file) {
        return Result.suppress(() -> Json.parse(file).asObject()).get(Result::WARN);
    }

    public static Optional<JsonObject> readSuppressing(InputStream is) {
        return Result.suppress(() -> Json.parse(is).asObject()).get(Result::WARN);
    }

    public static Result<JsonValue, SyntaxException> readValue(String contents) {
        return Result.of(() -> Json.parse(contents)).ifErr(Result::IGNORE);
    }

    public static <T> Optional<T> readOptional(Codec<T> codec, JsonValue value) {
        return codec.parse((DynamicOps)XjsOps.INSTANCE, (Object)value).result();
    }

    public static <T> T readThrowing(Codec<T> codec, JsonValue value) {
        return (T)codec.parse((DynamicOps)XjsOps.INSTANCE, (Object)value).getOrThrow(partial -> {
            throw new JsonFormatException((String)partial);
        });
    }

    public static Result<Void, IOException> writeJson(JsonObject json, File file) {
        return Result.with(() -> new FileWriter(file), writer -> json.write(file)).ifErr(e -> log.error("Writing file", (Throwable)e));
    }

    public static <A> Optional<JsonValue> writeSuppressing(Codec<A> codec, @Nullable A a) {
        if (a == null) {
            return Optional.of(JsonLiteral.jsonNull());
        }
        return codec.encodeStart((DynamicOps)XjsOps.INSTANCE, a).result();
    }

    public static <A> JsonValue writeThrowing(Codec<A> codec, @Nullable A a) {
        if (a == null) {
            return JsonLiteral.jsonNull();
        }
        return (JsonValue)codec.encodeStart((DynamicOps)XjsOps.INSTANCE, a).result().orElseThrow(() -> new JsonFormatException("Writing object: " + String.valueOf(a)));
    }

    @CheckReturnValue
    public static Result<Void, IOException> updateJson(File file, Consumer<JsonObject> f) {
        JsonObject json = XjsUtils.readJson(file).orElseGet(JsonObject::new);
        f.accept(json);
        return XjsUtils.writeJson(json, file);
    }

    public static JsonWriterOptions noCr() {
        return JsonContext.getDefaultFormatting().setEol("\n");
    }

    public static void setValueFromPath(JsonObject json, JsonPath path, @Nullable JsonValue value) {
        if (path.isEmpty()) {
            return;
        }
        Either<String, Integer> lastVal = path.get(path.size() - 1);
        JsonContainer parent = XjsUtils.getLastContainer(json, path);
        if (value != null && value.getLinesAbove() == -1 && XjsUtils.condenseNewValue(path, parent)) {
            value.setLinesAbove(0);
        }
        XjsUtils.setEither(parent, lastVal, value);
    }

    private static boolean condenseNewValue(JsonPath path, JsonContainer container) {
        int s;
        if (container.isEmpty()) {
            return true;
        }
        for (int i = s = path.size() == 1 && container.isObject() ? 1 : 0; i < container.size(); ++i) {
            if (container.getReference(i).getOnly().getLinesAbove() != 0) continue;
            return true;
        }
        return false;
    }

    public static Optional<JsonValue> getValueFromPath(JsonObject json, JsonPath path) {
        if (path.isEmpty()) {
            return Optional.empty();
        }
        Either<String, Integer> lastVal = path.get(path.size() - 1);
        return XjsUtils.getEither(XjsUtils.getLastContainer(json, path), lastVal);
    }

    public static JsonContainer getLastContainer(JsonObject json, JsonPath path) {
        if (path.isEmpty()) {
            return json;
        }
        JsonContainer current = json;
        for (int i = 0; i < path.size() - 1; ++i) {
            Either<String, Integer> val = path.get(i);
            Either<String, Integer> peek = path.get(i + 1);
            current = val.right().isPresent() ? XjsUtils.getOrTryNew(current.asArray(), (Integer)val.right().get(), peek) : (peek.left().isPresent() ? (JsonContainer)((JsonValue)current).asObject().getOptional((String)val.left().orElseThrow(), JsonValue::asObject).orElseGet(Json::object) : (JsonContainer)((JsonValue)current).asObject().getOptional((String)val.left().orElseThrow(), JsonValue::asArray).orElseGet(Json::array));
        }
        return current;
    }

    public static int getLastAvailable(JsonObject json, JsonPath path) {
        MutableObject current = new MutableObject((Object)json);
        int index = -1;
        for (Either<String, Integer> component : path) {
            component.ifLeft(key -> {
                JsonValue value = (JsonValue)current.getValue();
                if (value.isObject()) {
                    current.setValue((Object)value.asObject().get((String)key));
                } else {
                    current.setValue(null);
                }
            }).ifRight(i -> {
                JsonValue value = (JsonValue)current.getValue();
                if (value.isArray() && i < value.asArray().size()) {
                    current.setValue((Object)value.asArray().get((int)i));
                } else {
                    current.setValue(null);
                }
            });
            if (current.getValue() == null) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public static JsonPath getClosestMatch(JsonObject json, JsonPath path) {
        MutableObject current = new MutableObject((Object)json);
        JsonPath.JsonPathBuilder builder = JsonPath.builder();
        for (int i = 0; i < path.size(); ++i) {
            path.get(i).ifLeft(key -> {
                JsonValue value = (JsonValue)current.getValue();
                while (value.isArray() && !value.asArray().isEmpty()) {
                    builder.index(0);
                    value = value.asArray().get(0);
                }
                if (value.isObject() && value.asObject().has((String)key)) {
                    current.setValue((Object)value.asObject().get((String)key));
                    builder.key((String)key);
                } else {
                    current.setValue(null);
                }
            }).ifRight(index -> {
                JsonValue value = (JsonValue)current.getValue();
                if (value.isArray() && value.asArray().size() > index) {
                    current.setValue((Object)value.asArray().get((int)index));
                    builder.index((int)index);
                } else if (!value.isObject() || index != 0) {
                    current.setValue(null);
                }
            });
            if (current.getValue() != null) continue;
            return builder.build().append(path, i);
        }
        return builder.build();
    }

    public static JsonObject filter(JsonObject json, Collection<JsonPath> paths) {
        return XjsUtils.filter(json, paths, false);
    }

    public static JsonObject filter(JsonObject json, Collection<JsonPath> paths, boolean blacklist) {
        JsonObject clone = (JsonObject)json.deepCopy();
        paths.forEach(path -> path.getValue(clone));
        return XjsUtils.skip(clone, blacklist);
    }

    public static JsonObject skip(JsonObject json, boolean used) {
        JsonObject generated = (JsonObject)new JsonObject().setDefaultMetadata(json);
        StringBuilder skipped = new StringBuilder();
        for (JsonObject.Member member : json) {
            JsonValue value = member.getOnly();
            String name = member.getKey();
            if (member.getReference().isAccessed() != used) {
                if (skipped.length() > 0) {
                    value.prependComment("Skipped " + String.valueOf(skipped));
                    skipped.setLength(0);
                }
                if (value.isObject()) {
                    generated.add(name, XjsUtils.skip(value.asObject(), used));
                    continue;
                }
                if (value.isArray()) {
                    generated.add(name, XjsUtils.skip(value.asArray(), used));
                    continue;
                }
                generated.add(name, value);
                continue;
            }
            if (skipped.length() == 0) {
                skipped.append(name);
                continue;
            }
            skipped.append(", ").append(name);
        }
        if (skipped.length() > 0) {
            generated.prependComment(CommentType.INTERIOR, "Skipped " + String.valueOf(skipped));
        }
        return generated;
    }

    public static JsonArray skip(JsonArray json, boolean used) {
        JsonArray generated = (JsonArray)new JsonArray().setDefaultMetadata(json);
        int lastIndex = 0;
        int index = 0;
        for (JsonReference reference : json.references()) {
            JsonValue value = reference.getOnly();
            if (reference.isAccessed() != used) {
                if (index == lastIndex + 1) {
                    value.prependComment("Skipped " + (index - 1));
                } else if (index > lastIndex) {
                    value.prependComment("Skipped " + lastIndex + " ~ " + (index - 1));
                }
                if (value.isObject()) {
                    generated.add(XjsUtils.skip(value.asObject(), used));
                } else if (value.isArray()) {
                    generated.add(XjsUtils.skip(value.asArray(), used));
                } else {
                    generated.add(value);
                }
                lastIndex = index + 1;
            }
            ++index;
        }
        if (index == lastIndex + 1) {
            generated.prependComment(CommentType.INTERIOR, "Skipped " + (index - 1));
        } else if (index > lastIndex) {
            generated.prependComment(CommentType.INTERIOR, "Skipped " + lastIndex + " ~ " + (index - 1));
        }
        return generated;
    }

    public static List<String> getPaths(JsonObject json, JsonPath path) {
        JsonValue container = Result.of(() -> XjsUtils.getLastContainer(json, path)).get(Result::WARN).orElse(json);
        int end = path.size() - 1;
        if (end < 0) {
            return XjsUtils.getNeighbors("", container);
        }
        Optional<JsonValue> v = XjsUtils.getEither(container, path.get(end)).filter(value -> value.isObject() || value.isArray());
        if (v.isPresent()) {
            ++end;
        }
        String dir = JsonPath.serialize(path.subList(0, end));
        return XjsUtils.getNeighbors(dir, v.orElse(container));
    }

    private static List<String> getNeighbors(String dir, JsonValue container) {
        ArrayList<String> neighbors;
        block3: {
            block2: {
                neighbors = new ArrayList<String>();
                if (!container.isObject()) break block2;
                for (JsonObject.Member member : container.asObject()) {
                    String name = member.getKey();
                    neighbors.add(dir.isEmpty() ? name : InvalidEnumConstantException.f("{}.{}", dir, name));
                }
                break block3;
            }
            if (!container.isArray()) break block3;
            for (int i = 0; i < container.asArray().size(); ++i) {
                neighbors.add(InvalidEnumConstantException.f("{}[{}]", dir, i));
            }
        }
        return neighbors;
    }

    private static JsonContainer getOrTryNew(JsonArray array, int index, Either<String, Integer> type) {
        if (index == array.size()) {
            type.ifLeft(s -> array.add(new JsonObject())).ifRight(i -> array.add(new JsonArray()));
        }
        return array.get(index).asContainer();
    }

    private static Optional<JsonValue> getEither(JsonValue container, Either<String, Integer> either) {
        if (either.left().isPresent()) {
            return XjsUtils.nullable(container.asObject().get((String)either.left().get()));
        }
        if (either.right().isPresent()) {
            JsonArray array = container.asArray();
            int index = (Integer)either.right().get();
            return index < array.size() ? Optional.of(array.get(index)) : Optional.empty();
        }
        throw new UnreachableException();
    }

    private static void setEither(JsonValue container, Either<String, Integer> either, @Nullable JsonValue value) {
        if (either.left().isPresent()) {
            if (value == null) {
                container.asObject().remove((String)either.left().get());
            } else if (value.hasComments()) {
                container.asObject().set((String)either.left().get(), value);
            } else {
                String key = (String)either.left().get();
                JsonObject object = container.asObject();
                object.set(key, value);
            }
        } else if (either.right().isPresent()) {
            if (value == null) {
                container.asArray().remove((Integer)either.right().get());
            } else if (value.hasComments()) {
                container.asArray().set((int)((Integer)either.right().get()), value);
            } else {
                int index = (Integer)either.right().get();
                JsonArray array = container.asArray();
                XjsUtils.setOrAdd(array, index, value);
            }
        }
    }

    public static JsonObject addToArray(JsonObject json, String field, JsonValue value) {
        JsonValue array = json.get(field);
        if (array == null) {
            array = new JsonArray();
            json.add(field, array);
        } else if (!array.isArray()) {
            array = new JsonArray().add(array);
            json.set(field, array);
        }
        array.asArray().add(value);
        return json;
    }

    public static JsonArray setOrAdd(JsonArray array, int index, JsonValue value) {
        if (index == array.size()) {
            return array.add(value);
        }
        return array.set(index, value);
    }

    public static List<JsonObject> getObjectArray(JsonObject json, String field) {
        ArrayList<JsonObject> array = new ArrayList<JsonObject>();
        json.getOptional(field).map(JsonValue::intoArray).ifPresent(a -> XjsUtils.flatten(array, a));
        return array;
    }

    private static void flatten(List<JsonObject> array, JsonArray source) {
        for (JsonValue value : source) {
            if (value.isArray()) {
                XjsUtils.flatten(array, value.asArray());
                continue;
            }
            if (value.isObject()) {
                array.add(value.asObject());
                continue;
            }
            throw new JsonFormatException(InvalidEnumConstantException.f("Expected an array or object: {}", value));
        }
    }

    public static List<JsonObject> getRegularObjects(JsonObject json, String field) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        JsonArray array = json.getOptional(field).map(JsonValue::intoArray).orElseGet(JsonArray::new);
        XjsUtils.flattenRegularObjects(list, array);
        return list;
    }

    private static void flattenRegularObjects(List<JsonObject> array, JsonArray source) {
        for (JsonValue value : source) {
            if (value.isArray()) {
                XjsUtils.flattenRegularObjects(array, value.asArray());
                continue;
            }
            if (!value.isObject()) continue;
            array.add(value.asObject());
        }
    }

    public static JsonArray getOrCreateArray(JsonObject json, String field) {
        JsonValue jsonValue = json.get(field);
        if (jsonValue instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonValue;
            return array;
        }
        JsonArray array = Json.array();
        json.set(field, array);
        return array;
    }

    public static JsonObject getOrCreateObject(JsonObject json, String field) {
        JsonValue jsonValue = json.get(field);
        if (jsonValue instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonValue;
            return object;
        }
        JsonObject object = Json.object();
        json.set(field, object);
        return object;
    }

    @NotNull
    private static <T> Optional<T> nullable(@Nullable T val) {
        return Optional.ofNullable(val);
    }

    @Generated
    private XjsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

