/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.debug.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.core.client.api.FrustumUtil;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_863;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WindDebugRenderer
implements class_863.class_864 {
    private final class_310 minecraft;
    private List<class_243> accessedWindPositions = Collections.emptyList();
    private List<List<Pair<class_243, Integer>>> windNodes = Collections.emptyList();

    public WindDebugRenderer(class_310 client) {
        this.minecraft = client;
    }

    public void tick() {
        this.accessedWindPositions = ClientWindManager.getAccessedPositions();
        this.windNodes = ImmutableList.copyOf(this.createAllWindNodes());
    }

    public void method_20414() {
        this.accessedWindPositions = Collections.emptyList();
        this.windNodes = Collections.emptyList();
    }

    public void method_23109(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        WindDebugRenderer.renderWindNodesFromList(matrices, vertexConsumers, cameraX, cameraY, cameraZ, this.windNodes);
    }

    @NotNull
    private List<List<Pair<class_243, Integer>>> createAllWindNodes() {
        ArrayList<List<Pair<class_243, Integer>>> windNodes = new ArrayList<List<Pair<class_243, Integer>>>();
        this.accessedWindPositions.forEach(vec3 -> {
            if (FrustumUtil.isVisible(vec3, 0.5)) {
                windNodes.add(WindDebugRenderer.createWindNodes((class_1937)this.minecraft.field_1687, vec3, 1.5, false));
            }
        });
        return windNodes;
    }

    @NotNull
    protected static List<Pair<class_243, Integer>> createWindNodes(class_1937 level, class_243 origin, double stretch, boolean disturbanceOnly) {
        ArrayList<Pair<class_243, Integer>> windNodes = new ArrayList<Pair<class_243, Integer>>();
        class_243 wind = disturbanceOnly ? ClientWindManager.getRawDisturbanceMovement(level, origin) : ClientWindManager.getWindMovement(level, origin);
        double windlength = wind.method_1033();
        if (windlength != 0.0) {
            int increments = 3;
            class_243 lineStart = origin;
            double windLineScale = 1.0 / (double)increments * stretch;
            windNodes.add((Pair<class_243, Integer>)Pair.of((Object)lineStart, (Object)WindDebugRenderer.calculateNodeColor(Math.min(1.0, wind.method_1033()), disturbanceOnly)));
            for (int i = 0; i < increments; ++i) {
                class_243 lineEnd = lineStart.method_1019(wind.method_1021(windLineScale));
                windNodes.add((Pair<class_243, Integer>)Pair.of((Object)lineEnd, (Object)WindDebugRenderer.calculateNodeColor(Math.min(1.0, wind.method_1033()), disturbanceOnly)));
                lineStart = lineEnd;
                wind = disturbanceOnly ? ClientWindManager.getRawDisturbanceMovement(level, lineStart) : ClientWindManager.getWindMovement(level, lineStart);
            }
        }
        return windNodes;
    }

    protected static int calculateNodeColor(double strength, boolean disturbanceOnly) {
        return class_5253.class_5254.method_27764((int)255, (int)((int)class_3532.method_16436((double)strength, (double)255.0, (double)0.0)), (int)((int)class_3532.method_16436((double)strength, (double)90.0, (double)255.0)), (int)(disturbanceOnly ? 0 : 255));
    }

    protected static void renderWindNodesFromList(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ, @NotNull List<List<Pair<class_243, Integer>>> windNodes) {
        windNodes.forEach(nodes -> WindDebugRenderer.renderWindNodes(matrices, vertexConsumers, cameraX, cameraY, cameraZ, nodes));
    }

    protected static void renderWindNodes(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ, @NotNull List<Pair<class_243, Integer>> windNodes) {
        int size = windNodes.size();
        if (size > 1) {
            for (int i = 1; i < windNodes.size(); ++i) {
                Pair<class_243, Integer> startNode = windNodes.get(i - 1);
                Pair<class_243, Integer> endNode = windNodes.get(i);
                WindDebugRenderer.drawLine(matrices, vertexConsumers, cameraX, cameraY, cameraZ, (class_243)startNode.getFirst(), (class_243)endNode.getFirst(), (Integer)startNode.getSecond());
            }
        }
    }

    private static void drawLine(@NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ, @NotNull class_243 start, @NotNull class_243 target, int color) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_49043((double)24.0));
        vertexConsumer.method_56824(matrices.method_23760(), (float)(start.field_1352 - cameraX), (float)(start.field_1351 - cameraY), (float)(start.field_1350 - cameraZ)).method_39415(color);
        vertexConsumer.method_56824(matrices.method_23760(), (float)(target.field_1352 - cameraX), (float)(target.field_1351 - cameraY), (float)(target.field_1350 - cameraZ)).method_39415(color);
    }
}

