/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.debug.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.core.client.api.FrustumUtil;
import net.frozenblock.lib.debug.client.renderer.WindDebugRenderer;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_863;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WindDisturbanceDebugRenderer
implements class_863.class_864 {
    private final class_310 minecraft;
    private List<WindDisturbance<?>> windDisturbances = Collections.emptyList();
    private List<List<Pair<class_243, Integer>>> windNodes = Collections.emptyList();

    public WindDisturbanceDebugRenderer(class_310 client) {
        this.minecraft = client;
    }

    public void tick() {
        this.windDisturbances = ImmutableList.copyOf(ClientWindManager.getWindDisturbances());
        this.windNodes = ImmutableList.copyOf(this.createAllWindNodes());
    }

    public void method_20414() {
        this.windDisturbances = Collections.emptyList();
        this.windNodes = Collections.emptyList();
    }

    public void method_23109(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        this.windDisturbances.forEach(windDisturbance -> {
            class_761.method_22983((class_4587)matrices, (class_4588)vertexConsumers.getBuffer(class_1921.method_23594()), (class_265)class_259.method_1078((class_238)windDisturbance.affectedArea), (double)(-cameraX), (double)(-cameraY), (double)(-cameraZ), (float)0.5f, (float)1.0f, (float)0.5f, (float)0.35f, (boolean)true);
            WindDisturbanceDebugRenderer.renderFilledBox(matrices, vertexConsumers, class_238.method_30048((class_243)windDisturbance.origin, (double)0.2, (double)0.2, (double)0.2), cameraX, cameraY, cameraZ);
        });
        WindDebugRenderer.renderWindNodesFromList(matrices, vertexConsumers, cameraX, cameraY, cameraZ, this.windNodes);
    }

    @NotNull
    private List<List<Pair<class_243, Integer>>> createAllWindNodes() {
        ArrayList<List<Pair<class_243, Integer>>> windNodes = new ArrayList<List<Pair<class_243, Integer>>>();
        this.windDisturbances.forEach(windDisturbance -> {
            if (FrustumUtil.isVisible(windDisturbance.affectedArea)) {
                class_2338.method_10097((class_2338)class_2338.method_49638((class_2374)windDisturbance.affectedArea.method_61125()), (class_2338)class_2338.method_49638((class_2374)windDisturbance.affectedArea.method_61126())).forEach(blockPos -> {
                    class_243 blockPosCenter = class_243.method_24953((class_2382)blockPos);
                    windNodes.add(WindDebugRenderer.createWindNodes((class_1937)this.minecraft.field_1687, blockPosCenter, 1.0, true));
                });
            }
        });
        return windNodes;
    }

    private static void renderFilledBox(class_4587 matrices, class_4597 vertexConsumers, @NotNull class_238 box, double cameraX, double cameraY, double cameraZ) {
        class_243 vec3 = new class_243(-cameraX, -cameraY, -cameraZ);
        class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)box.method_997(vec3), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

