/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.item.api.removable;

import java.util.LinkedHashMap;
import java.util.Set;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.item.api.removable.RemovalPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RemovableItemTags {
    private static final LinkedHashMap<String, RemovableItemTag> REMOVABLE_ITEM_TAGS = new LinkedHashMap();

    public static void register(String tagKey, RemovalPredicate removalPredicate, boolean removeOnStackMerge) {
        REMOVABLE_ITEM_TAGS.put(tagKey, new RemovableItemTag(tagKey, removalPredicate, removeOnStackMerge));
    }

    public static boolean canRemoveTag(String tagKey, class_1937 level, class_1297 entity, int slot, boolean selected) {
        RemovableItemTag removableItemTag = REMOVABLE_ITEM_TAGS.get(tagKey);
        if (removableItemTag != null) {
            return removableItemTag.shouldRemove(level, entity, slot, selected);
        }
        FrozenLibLogUtils.logError("Unable to find RemovableItemTag data for TagKey " + tagKey + "!", true, null);
        FrozenLibLogUtils.logError("Please make sure " + tagKey + " is registered in RemovableItemTags.class!", true, null);
        return false;
    }

    public static boolean shouldRemoveTagOnStackMerge(String tagKey) {
        RemovableItemTag removableItemTag = REMOVABLE_ITEM_TAGS.get(tagKey);
        if (removableItemTag != null) {
            return removableItemTag.shouldRemoveOnStackMerge();
        }
        FrozenLibLogUtils.logError("Unable to find RemovableItemTag data for TagKey " + tagKey + "!", true, null);
        FrozenLibLogUtils.logError("Please make sure " + tagKey + " is registered in RemovableItemTags.class!", true, null);
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static Set<String> keys() {
        return REMOVABLE_ITEM_TAGS.keySet();
    }

    public static class RemovableItemTag
    implements RemovalPredicate {
        private final String tagKey;
        private final RemovalPredicate predicate;
        private final boolean removeOnStackMerge;

        public RemovableItemTag(String tagKey, RemovalPredicate predicate, boolean removeOnStackMerge) {
            this.tagKey = tagKey;
            this.predicate = predicate;
            this.removeOnStackMerge = removeOnStackMerge;
        }

        public String getTagKey() {
            return this.tagKey;
        }

        @Override
        public boolean shouldRemove(class_1937 level, class_1297 entity, int slot, boolean selected) {
            return this.predicate.shouldRemove(level, entity, slot, selected);
        }

        public boolean shouldRemoveOnStackMerge() {
            return this.removeOnStackMerge;
        }
    }
}

