/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.util;

import java.util.Arrays;
import java.util.List;

public class HashIndexTable {
    protected final byte[] indices = new byte[32];

    public void init(List<?> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.add(values.get(i), i);
        }
    }

    public void add(Object key, int index) {
        int slot = this.getSlot(key);
        this.indices[slot] = index < 255 ? (byte)(index + 1) : (byte)0;
    }

    public void remove(int index) {
        for (int i = 0; i < this.indices.length; ++i) {
            int current = this.indices[i] & 0xFF;
            if (current == index + 1) {
                this.indices[i] = 0;
                continue;
            }
            if (current <= index + 1) continue;
            int n = i;
            this.indices[n] = (byte)(this.indices[n] - 1);
        }
    }

    public int get(Object key) {
        return (this.indices[this.getSlot(key)] & 0xFF) - 1;
    }

    private int getSlot(Object key) {
        return key.hashCode() & this.indices.length - 1;
    }

    public void clear() {
        Arrays.fill(this.indices, (byte)0);
    }
}

