/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.tag.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.fabricmc.fabric.api.tag.convention.v1.TagUtil;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TagUtils {
    @NotNull
    public static <T> List<T> getAllEntries(@NotNull class_6862<T> tag) {
        class_2378 registry;
        Optional maybeRegistry = class_7923.field_41167.method_17966(tag.comp_326().method_29177());
        if (maybeRegistry.isPresent() && tag.method_41007((registry = (class_2378)maybeRegistry.get()).method_30517())) {
            ArrayList entries = new ArrayList();
            for (class_6880 entry : registry.method_40286(tag)) {
                Optional optionalKey = entry.method_40230();
                if (!optionalKey.isPresent()) continue;
                class_5321 key = (class_5321)optionalKey.get();
                registry.method_31189(key).ifPresent(entries::add);
            }
            if (!entries.isEmpty()) {
                return entries;
            }
        }
        return List.of();
    }

    @Nullable
    public static <T> T getRandomEntry(class_6862<T> tag) {
        return TagUtils.getRandomEntry(AdvancedMath.random(), tag);
    }

    @Nullable
    public static <T> T getRandomEntry(class_5819 random, class_6862<T> tag) {
        class_2378 registry;
        Optional maybeRegistry = class_7923.field_41167.method_17966(tag.comp_326().method_29177());
        Objects.requireNonNull(random);
        Objects.requireNonNull(tag);
        if (maybeRegistry.isPresent() && tag.method_41007((registry = (class_2378)maybeRegistry.get()).method_30517())) {
            ArrayList entries = new ArrayList();
            for (class_6880 entry : registry.method_40286(tag)) {
                Optional optionalKey = entry.method_40230();
                if (!optionalKey.isPresent()) continue;
                class_5321 key = (class_5321)optionalKey.get();
                registry.method_31189(key).ifPresent(entries::add);
            }
            if (!entries.isEmpty()) {
                return (T)entries.get(random.method_43048(entries.size()));
            }
        }
        return null;
    }

    public static <T> boolean isIn(class_6862<T> tagKey, T entry) {
        return TagUtil.isIn(tagKey, entry);
    }

    public static <T> boolean isIn(@Nullable class_5455 registryAccess, class_6862<T> tagKey, T entry) {
        return TagUtil.isIn((class_5455)registryAccess, tagKey, entry);
    }

    @Generated
    private TagUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

