/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.wind.api;

import java.util.Optional;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.registry.FrozenLibRegistries;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_8949;
import net.minecraft.class_9236;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class WindDisturbanceLogic<T> {
    public static final class_2960 DEFAULT_ID = FrozenLibConstants.id("default");
    public static final class_2960 BREEZE = FrozenLibConstants.id("breeze");
    public static final class_2960 WIND_CHARGE = FrozenLibConstants.id("wind_charge");
    public static final WindDisturbanceLogic DUMMY_LOGIC = new WindDisturbanceLogic((source, level, windOrigin, affectedArea, windTarget) -> WindDisturbance.DUMMY_RESULT);
    private final DisturbanceLogic<T> disturbanceLogic;
    private static final double WIND_RANGE_BREEZE = 6.0;
    private static final double WIND_RANGE_WIND_CHARGE = 5.0;

    public WindDisturbanceLogic(DisturbanceLogic<T> disturbanceLogic) {
        this.disturbanceLogic = disturbanceLogic;
    }

    public DisturbanceLogic getLogic() {
        return this.disturbanceLogic;
    }

    public static Optional<WindDisturbanceLogic> getWindDisturbanceLogic(class_2960 id) {
        if (id != null) {
            WindDisturbanceLogic disturbanceLogic;
            if (FrozenLibRegistries.WIND_DISTURBANCE_LOGIC.method_10250(id)) {
                WindDisturbanceLogic disturbanceLogic2 = (WindDisturbanceLogic)FrozenLibRegistries.WIND_DISTURBANCE_LOGIC.method_10223(id);
                if (disturbanceLogic2 != null) {
                    return Optional.of(disturbanceLogic2);
                }
            } else if (FrozenLibRegistries.WIND_DISTURBANCE_LOGIC_UNSYNCED.method_10250(id) && (disturbanceLogic = (WindDisturbanceLogic)FrozenLibRegistries.WIND_DISTURBANCE_LOGIC_UNSYNCED.method_10223(id)) != null) {
                return Optional.of(disturbanceLogic);
            }
            FrozenLibConstants.LOGGER.error("Unable to find wind disturbance logic " + String.valueOf(id) + "!");
        }
        return Optional.empty();
    }

    @NotNull
    @Contract(pure=true)
    public static DisturbanceLogic<?> defaultPredicate() {
        return (source, level, windOrigin, affectedArea, windTarget) -> WindDisturbance.DUMMY_RESULT;
    }

    public static void init() {
        WindDisturbanceLogic.register(DEFAULT_ID, WindDisturbanceLogic.defaultPredicate());
        WindDisturbanceLogic.register(BREEZE, WindDisturbanceLogic.breeze());
        WindDisturbanceLogic.register(WIND_CHARGE, WindDisturbanceLogic.windCharge());
    }

    public static <T> void register(class_2960 id, DisturbanceLogic<T> predicate) {
        class_2378.method_10230(FrozenLibRegistries.WIND_DISTURBANCE_LOGIC, (class_2960)id, new WindDisturbanceLogic<T>(predicate));
    }

    public static <T> void registerUnsynced(class_2960 id, DisturbanceLogic<T> predicate) {
        class_2378.method_10230(FrozenLibRegistries.WIND_DISTURBANCE_LOGIC_UNSYNCED, (class_2960)id, new WindDisturbanceLogic<T>(predicate));
    }

    @NotNull
    @Contract(pure=true)
    private static DisturbanceLogic<class_8949> breeze() {
        return (source, level, windOrigin, affectedArea, windTarget) -> {
            if (source.isEmpty()) {
                return null;
            }
            double distance = windOrigin.method_1022(windTarget);
            if (distance <= 6.0) {
                class_243 breezeLookVec = ((class_8949)source.get()).method_5663();
                class_243 differenceInPoses = windOrigin.method_1020(windTarget);
                double scaledDistance = (6.0 - distance) / 6.0;
                double strengthFromDistance = class_3532.method_15350((double)((6.0 - distance) / 4.5), (double)0.0, (double)1.0);
                double angleBetween = AdvancedMath.getAngleBetweenXZ(breezeLookVec, differenceInPoses);
                double x = Math.cos(angleBetween * Math.PI / 180.0);
                double z = -Math.sin(angleBetween * Math.PI / 180.0);
                x = -class_3532.method_16436((double)scaledDistance, (double)((x - differenceInPoses.field_1352 * 0.45) * 0.5), (double)x);
                z = -class_3532.method_16436((double)scaledDistance, (double)((z - differenceInPoses.field_1350 * 0.45) * 0.5), (double)z);
                class_243 windVec = new class_243(x, strengthFromDistance, z).method_1021(1.0);
                return new WindDisturbance.DisturbanceResult(strengthFromDistance, 6.0 - distance, windVec);
            }
            return null;
        };
    }

    @NotNull
    @Contract(pure=true)
    private static DisturbanceLogic<class_9236> windCharge() {
        return (source, level, windOrigin, affectedArea, windTarget) -> {
            if (source.isEmpty()) {
                return null;
            }
            double distance = windOrigin.method_1022(windTarget);
            if (distance <= 5.0) {
                class_243 chargeMovement = ((class_9236)source.get()).method_18798();
                double strengthFromDistance = class_3532.method_15350((double)((5.0 - distance) / 2.5), (double)0.0, (double)1.0);
                class_243 windVec = new class_243(chargeMovement.field_1352, chargeMovement.field_1351, chargeMovement.field_1350).method_1021(3.0 * strengthFromDistance);
                return new WindDisturbance.DisturbanceResult(strengthFromDistance, (5.0 - distance) * 2.0, windVec);
            }
            return null;
        };
    }

    @FunctionalInterface
    public static interface DisturbanceLogic<T> {
        public WindDisturbance.DisturbanceResult calculateDisturbanceResult(Optional<T> var1, class_1937 var2, class_243 var3, class_238 var4, class_243 var5);
    }

    public static enum SourceType {
        ENTITY,
        BLOCK_ENTITY,
        BLOCK,
        NONE;

    }
}

