/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature.disk.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.worldgen.feature.api.feature.disk.config.BallOuterRingBlockPlacement;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6646;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class BallBlockPlacement {
    public static final Codec<BallBlockPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("state_provider").forGetter(config -> config.blockStateProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("placement_chance", (Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.placementChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("chance_to_choose_inner_block_in_outer_ring", (Object)Float.valueOf(0.0f)).forGetter(config -> Float.valueOf(config.chanceToChooseInnerBlockInOuterRing)), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("fade_start_percentage", (Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.fadeStartPercentage)), (App)class_6646.field_35054.fieldOf("replacement_block_predicate").forGetter(config -> config.replacementBlockPredicate), (App)class_6646.field_35054.fieldOf("searching_block_predicate").forGetter(config -> config.searchingBlockPredicate), (App)Codec.BOOL.lenientOptionalFieldOf("schedule_tick_on_placement", (Object)false).forGetter(config -> config.scheduleTickOnPlacement), (App)Codec.INT.lenientOptionalFieldOf("vertical_placement_offset", (Object)0).forGetter(config -> config.verticalPlacementOffset), (App)class_6895.method_40340((class_5321)class_7924.field_41236).lenientOptionalFieldOf("excluded_biomes").forGetter(config -> config.excludedBiomes), (App)BallOuterRingBlockPlacement.CODEC.lenientOptionalFieldOf("outer_placement").forGetter(config -> config.outerRingBlockPlacement)).apply((Applicative)instance, BallBlockPlacement::new));
    private final class_4651 blockStateProvider;
    private final float placementChance;
    private final float chanceToChooseInnerBlockInOuterRing;
    private final float fadeStartPercentage;
    private final class_6646 replacementBlockPredicate;
    private final class_6646 searchingBlockPredicate;
    private final boolean scheduleTickOnPlacement;
    private final int verticalPlacementOffset;
    private final Optional<class_6885<class_1959>> excludedBiomes;
    private final Optional<BallOuterRingBlockPlacement> outerRingBlockPlacement;

    public BallBlockPlacement(class_4651 blockStateProvider, float placementChance, float chanceToChooseInnerBlockInOuterRing, float fadeStartPercentage, class_6646 replacementBlockPredicate, class_6646 searchingBlockPredicate, boolean scheduleTickOnPlacement, int verticalPlacementOffset, Optional<class_6885<class_1959>> excludedBiomes, Optional<BallOuterRingBlockPlacement> outerRingBlockPlacement) {
        this.blockStateProvider = blockStateProvider;
        this.placementChance = placementChance;
        this.chanceToChooseInnerBlockInOuterRing = chanceToChooseInnerBlockInOuterRing;
        this.fadeStartPercentage = fadeStartPercentage;
        this.replacementBlockPredicate = replacementBlockPredicate;
        this.searchingBlockPredicate = searchingBlockPredicate;
        this.scheduleTickOnPlacement = scheduleTickOnPlacement;
        this.verticalPlacementOffset = verticalPlacementOffset;
        this.excludedBiomes = excludedBiomes;
        this.outerRingBlockPlacement = outerRingBlockPlacement;
    }

    public boolean generate(class_5281 level, class_2338 center, class_2338.class_2339 pos, boolean usingHeightmap, int placementRadius, @NotNull class_5819 random) {
        boolean fading;
        double distance = AdvancedMath.distanceBetween(center, (class_2338)pos, !usingHeightmap);
        if (distance > (double)placementRadius) {
            return false;
        }
        boolean bl = fading = distance >= (double)((float)placementRadius * this.fadeStartPercentage);
        if (!fading || random.method_43056()) {
            if (this.excludedBiomes.isPresent() && this.excludedBiomes.get().method_40241(level.method_23753((class_2338)pos))) {
                return false;
            }
            if (this.outerRingBlockPlacement.isPresent()) {
                BallOuterRingBlockPlacement outerRingBlockPlacement = this.outerRingBlockPlacement.get();
                BallOuterRingBlockPlacement.OuterRingSelectionType selectionType = outerRingBlockPlacement.chooseSelectionType(distance, placementRadius, this.chanceToChooseInnerBlockInOuterRing, random);
                if (selectionType == BallOuterRingBlockPlacement.OuterRingSelectionType.OUTER_IN_INNER) {
                    if (random.method_43057() <= outerRingBlockPlacement.getPlacementChance()) {
                        return outerRingBlockPlacement.generate(level, pos, random, true);
                    }
                } else if (selectionType == BallOuterRingBlockPlacement.OuterRingSelectionType.SUCCESS) {
                    return outerRingBlockPlacement.generate(level, pos, random, false);
                }
            }
            if (random.method_43057() <= this.placementChance) {
                return this.generateBlock(level, pos, random);
            }
        }
        return false;
    }

    public boolean generateBlock(class_5281 level, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2338.class_2339 pos, class_5819 random) {
        pos.method_10100(0, this.verticalPlacementOffset, 0);
        if (this.replacementBlockPredicate.test((Object)level, (Object)pos) && this.searchingBlockPredicate.test((Object)level, (Object)pos)) {
            class_2680 state = this.blockStateProvider.method_23455(random, (class_2338)pos);
            level.method_8652((class_2338)pos, state, 2);
            if (this.scheduleTickOnPlacement) {
                level.method_39279((class_2338)pos, state.method_26204(), 1);
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        private final class_4651 blockStateProvider;
        private float placementChance = 1.0f;
        private float chanceToChooseInnerBlockInOuterRing = 0.0f;
        private float fadeStartPercentage = 1.0f;
        private class_6646 replacementBlockPredicate = class_6646.method_38883();
        private class_6646 searchingBlockPredicate = class_6646.method_39011();
        private boolean scheduleTickOnPlacement = false;
        private int verticalPlacementOffset = 0;
        private Optional<class_6885<class_1959>> excludedBiomes = Optional.empty();
        private Optional<BallOuterRingBlockPlacement> outerRingBlockPlacement = Optional.empty();

        public Builder(class_4651 blockStateProvider) {
            this.blockStateProvider = blockStateProvider;
        }

        public Builder placementChance(float chance) {
            this.placementChance = chance;
            return this;
        }

        public Builder chanceToChooseInnerBlockInOuterRing(float chance) {
            this.chanceToChooseInnerBlockInOuterRing = chance;
            return this;
        }

        public Builder fadeStartPercentage(float fadeStartPercentage) {
            this.fadeStartPercentage = fadeStartPercentage;
            return this;
        }

        public Builder replacementBlockPredicate(class_6646 replacementBlockPredicate) {
            this.replacementBlockPredicate = replacementBlockPredicate;
            return this;
        }

        public Builder searchingBlockPredicate(class_6646 searchingBlockPredicate) {
            this.searchingBlockPredicate = searchingBlockPredicate;
            return this;
        }

        public Builder scheduleTickOnPlacement() {
            this.scheduleTickOnPlacement = true;
            return this;
        }

        public Builder verticalPlacementOffset(int verticalPlacementOffset) {
            this.verticalPlacementOffset = verticalPlacementOffset;
            return this;
        }

        public Builder excludedBiomes(class_6885<class_1959> excludedBiomes) {
            this.excludedBiomes = Optional.of(excludedBiomes);
            return this;
        }

        public Builder outerRingBlockPlacement(BallOuterRingBlockPlacement outerRingBlockPlacement) {
            this.outerRingBlockPlacement = Optional.of(outerRingBlockPlacement);
            return this;
        }

        public BallBlockPlacement build() {
            return new BallBlockPlacement(this.blockStateProvider, this.placementChance, this.chanceToChooseInnerBlockInOuterRing, this.fadeStartPercentage, this.replacementBlockPredicate, this.searchingBlockPredicate, this.scheduleTickOnPlacement, this.verticalPlacementOffset, this.excludedBiomes, this.outerRingBlockPlacement);
        }
    }
}

