/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.block.sound.impl.BlockSoundTypeManager;
import net.frozenblock.lib.cape.impl.ServerCapeData;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.config.impl.ConfigCommand;
import net.frozenblock.lib.core.impl.DataPackReloadMarker;
import net.frozenblock.lib.entity.api.command.ScaleEntityCommand;
import net.frozenblock.lib.entrypoint.api.FrozenMainEntrypoint;
import net.frozenblock.lib.entrypoint.api.FrozenModInitializer;
import net.frozenblock.lib.event.api.PlayerJoinEvents;
import net.frozenblock.lib.event.api.RegistryFreezeEvents;
import net.frozenblock.lib.integration.api.ModIntegrations;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.lib.particle.FrozenLibParticleTypes;
import net.frozenblock.lib.registry.FrozenLibRegistries;
import net.frozenblock.lib.screenshake.api.ScreenShakeManager;
import net.frozenblock.lib.screenshake.api.command.ScreenShakeCommand;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.spotting_icons.api.SpottingIconPredicate;
import net.frozenblock.lib.tag.api.TagKeyArgument;
import net.frozenblock.lib.tag.api.TagListCommand;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.api.command.WindCommand;
import net.frozenblock.lib.worldgen.feature.api.FrozenLibFeatures;
import net.frozenblock.lib.worldgen.feature.api.block_predicate.FrozenLibBlockPredicateTypes;
import net.frozenblock.lib.worldgen.feature.api.placementmodifier.FrozenPlacementModifiers;
import net.frozenblock.lib.worldgen.structure.api.StructureGenerationConditionApi;
import net.frozenblock.lib.worldgen.structure.api.StructurePlacementExclusionApi;
import net.frozenblock.lib.worldgen.structure.api.TemplatePoolApi;
import net.frozenblock.lib.worldgen.structure.impl.FrozenRuleBlockEntityModifiers;
import net.frozenblock.lib.worldgen.structure.impl.FrozenStructurePoolElementTypes;
import net.frozenblock.lib.worldgen.structure.impl.FrozenStructureProcessorTypes;
import net.frozenblock.lib.worldgen.structure.impl.StructureUpgradeCommand;
import net.frozenblock.lib.worldgen.structure.impl.status.StructureStatusUpdater;
import net.frozenblock.lib.worldgen.surface.impl.BiomeTagConditionSource;
import net.frozenblock.lib.worldgen.surface.impl.OptimizedBiomeTagConditionSource;
import net.minecraft.class_2168;
import net.minecraft.class_2316;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7240;
import net.minecraft.class_7923;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocol;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.server.ServerRegistrySync;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.ServerFreezer;

public final class FrozenLibMain
extends FrozenModInitializer {
    public FrozenLibMain() {
        super("frozenlib");
    }

    @Override
    public void onInitialize(String modId, ModContainer container) {
        FrozenLibRegistries.initRegistry();
        ServerFreezer.onInitialize();
        ModProtocol.loadVersions();
        ServerRegistrySync.registerHandlers();
        FrozenRuleBlockEntityModifiers.init();
        FrozenStructureProcessorTypes.init();
        FrozenStructurePoolElementTypes.init();
        SoundPredicate.init();
        SpottingIconPredicate.init();
        WindDisturbanceLogic.init();
        FrozenLibParticleTypes.init();
        FrozenLibFeatures.init();
        FrozenLibBlockPredicateTypes.init();
        FrozenPlacementModifiers.init();
        DataPackReloadMarker.init();
        StructureGenerationConditionApi.init();
        StructurePlacementExclusionApi.init();
        TemplatePoolApi.init();
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)FrozenLibConstants.id("biome_tag_condition_source"), (Object)BiomeTagConditionSource.CODEC.comp_640());
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)FrozenLibConstants.id("optimized_biome_tag_condition_source"), (Object)OptimizedBiomeTagConditionSource.CODEC.comp_640());
        ServerCapeData.init();
        ((FrozenMainEntrypoint)FrozenMainEntrypoint.EVENT.invoker()).init();
        class_2316.method_10017((class_2378)class_7923.field_41192, (String)FrozenLibConstants.string("tag_key"), (Class)class_2316.method_41181(TagKeyArgument.class), new TagKeyArgument.Info());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            WindCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ScreenShakeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ConfigCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TagListCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ScaleEntityCommand.register((CommandDispatcher<class_2168>)dispatcher);
            StructureUpgradeCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerWorldEvents.UNLOAD.register((server, serverLevel) -> WindManager.getOrCreateWindManager(serverLevel).clearAllWindDisturbances());
        ServerTickEvents.START_WORLD_TICK.register(serverLevel -> {
            WindManager.getOrCreateWindManager(serverLevel).clearAndSwitchWindDisturbances();
            WindManager.getOrCreateWindManager(serverLevel).tick(serverLevel);
            ScreenShakeManager.getOrCreateScreenShakeManager(serverLevel).tick(serverLevel);
            StructureStatusUpdater.updatePlayerStructureStatusesForLevel(serverLevel);
        });
        PlayerJoinEvents.ON_PLAYER_ADDED_TO_LEVEL.register((server, serverLevel, player) -> {
            WindManager windManager = WindManager.getOrCreateWindManager(serverLevel);
            windManager.sendSyncToPlayer(windManager.createSyncPacket(), player);
        });
        if (FrozenLibConfig.get().wardenSpawnTrackerCommand) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> class_7240.method_42100((CommandDispatcher)dispatcher));
        }
        FrozenNetworking.registerNetworking();
        RegistryFreezeEvents.START_REGISTRY_FREEZE.register((registry, allRegistries) -> {
            if (allRegistries) {
                ModIntegrations.initialize();
            }
        });
        RegistryFreezeEvents.END_REGISTRY_FREEZE.register((registry, allRegistries) -> {
            if (!allRegistries) {
                return;
            }
            for (Config<?> config : ConfigRegistry.getAllConfigs()) {
                config.save();
            }
        });
        ResourceManagerHelper resourceLoader = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        resourceLoader.registerReloadListener((IdentifiableResourceReloadListener)BlockSoundTypeManager.INSTANCE);
    }
}

