/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.screenshake.impl.EntityScreenShakeInterface;
import net.frozenblock.lib.screenshake.impl.ScreenShakeManagerInterface;
import net.frozenblock.lib.screenshake.impl.network.EntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.ScreenShakePacket;
import net.minecraft.class_10741;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class ScreenShakeManager
extends class_18 {
    public static final String SCREENSHAKE_MANAGER_FILE_ID = "frozenlib_screen_shakes";
    public static final Codec<ScreenShakeManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ScreenShake.LIST_CODEC.fieldOf("ScreenShakes").forGetter(screenshakeManager -> screenshakeManager.shakes)).apply((Applicative)instance, ScreenShakeManager::createFromCodec));
    public static final class_10741<ScreenShakeManager> TYPE = new class_10741("frozenlib_screen_shakes", ScreenShakeManager::new, CODEC, class_4284.field_45082);
    private final ArrayList<ScreenShake> shakes = new ArrayList();

    @NotNull
    public static ScreenShakeManager createFromCodec(List<ScreenShake> shakes) {
        ScreenShakeManager screenShakeManager = new ScreenShakeManager();
        screenShakeManager.shakes.addAll(shakes);
        return screenShakeManager;
    }

    public boolean method_79() {
        return true;
    }

    public void tick(@NotNull class_3218 level) {
        if (level.method_54719().method_54751()) {
            this.getShakes().removeIf(ScreenShake::shouldRemove);
            for (ScreenShake shake : this.getShakes()) {
                if (!level.method_14178().method_12123(shake.chunkPos.field_9181, shake.chunkPos.field_9180)) continue;
                ++shake.ticks;
                Collection playersTrackingChunk = PlayerLookup.tracking((class_3218)level, (class_1923)shake.chunkPos);
                for (class_3222 serverPlayer : playersTrackingChunk) {
                    if (shake.trackingPlayers.contains(serverPlayer)) continue;
                    ScreenShakeManager.sendScreenShakePacketTo(serverPlayer, shake.getIntensity(), shake.getDuration(), shake.getDurationFalloffStart(), shake.getPos(), shake.getMaxDistance(), shake.getTicks());
                }
                shake.trackingPlayers.clear();
                shake.trackingPlayers.addAll(playersTrackingChunk);
            }
        }
    }

    public void addShake(float intensity, int duration, int falloffStart, class_243 pos, float maxDistance, int ticks) {
        this.getShakes().add(new ScreenShake(intensity, duration, falloffStart, pos, maxDistance, ticks));
    }

    public static ScreenShakeManager getOrCreateScreenShakeManager(class_3218 level) {
        return ((ScreenShakeManagerInterface)level).frozenLib$getOrCreateScreenShakeManager();
    }

    public static void addScreenShake(class_1937 level, float intensity, double x, double y, double z, float maxDistance) {
        ScreenShakeManager.addScreenShake(level, intensity, 20, 5, x, y, z, maxDistance);
    }

    public static void addScreenShake(class_1937 level, float intensity, int duration, double x, double y, double z, float maxDistance) {
        ScreenShakeManager.addScreenShake(level, intensity, duration, 1, x, y, z, maxDistance);
    }

    public static void addScreenShake(class_1937 level, float intensity, int duration, int falloffStart, double x, double y, double z, float maxDistance) {
        ScreenShakeManager.addScreenShake(level, intensity, duration, falloffStart, x, y, z, maxDistance, 0);
    }

    public static void addScreenShake(@NotNull class_1937 level, float intensity, int duration, int falloffStart, double x, double y, double z, float maxDistance, int ticks) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ScreenShakeManager.getOrCreateScreenShakeManager(serverLevel).addShake(intensity, duration, falloffStart, new class_243(x, y, z), maxDistance, ticks);
        }
    }

    public static void sendScreenShakePacketTo(class_3222 player, float intensity, int duration, int falloffStart, class_243 pos, float maxDistance, int ticks) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ScreenShakePacket(intensity, duration, falloffStart, pos, maxDistance, ticks));
    }

    public static void addEntityScreenShake(class_1297 entity, float intensity, float maxDistance) {
        ScreenShakeManager.addEntityScreenShake(entity, intensity, 5, 1, maxDistance);
    }

    public static void addEntityScreenShake(class_1297 entity, float intensity, int duration, float maxDistance) {
        ScreenShakeManager.addEntityScreenShake(entity, intensity, duration, 1, maxDistance);
    }

    public static void addEntityScreenShake(class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance) {
        ScreenShakeManager.addEntityScreenShake(entity, intensity, duration, falloffStart, maxDistance, 0);
    }

    public static void addEntityScreenShake(@NotNull class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance, int ticks) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            EntityScreenShakePacket packet = new EntityScreenShakePacket(entity.method_5628(), intensity, duration, falloffStart, maxDistance, ticks);
            for (class_3222 player : PlayerLookup.world((class_3218)serverLevel)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
            ((EntityScreenShakeInterface)entity).frozenLib$addScreenShake(intensity, duration, falloffStart, maxDistance, ticks);
        }
    }

    public static void sendEntityScreenShakeTo(class_3222 player, @NotNull class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance, int ticks) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new EntityScreenShakePacket(entity.method_5628(), intensity, duration, falloffStart, maxDistance, ticks));
    }

    @Generated
    public ArrayList<ScreenShake> getShakes() {
        return this.shakes;
    }

    public static class ScreenShake {
        public static final Codec<ScreenShake> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("Intensity").forGetter(ScreenShake::getIntensity), (App)Codec.INT.fieldOf("Duration").forGetter(ScreenShake::getDuration), (App)Codec.INT.fieldOf("FalloffStart").forGetter(ScreenShake::getDurationFalloffStart), (App)class_243.field_38277.fieldOf("Position").forGetter(ScreenShake::getPos), (App)Codec.FLOAT.fieldOf("MaxDistance").forGetter(ScreenShake::getMaxDistance), (App)Codec.INT.fieldOf("Ticks").forGetter(ScreenShake::getTicks)).apply((Applicative)instance, ScreenShake::new));
        public static final Codec<List<ScreenShake>> LIST_CODEC = CODEC.listOf();
        public final int duration;
        public final float maxDistance;
        public final class_1923 chunkPos;
        private final float intensity;
        private final int durationFalloffStart;
        public int ticks;
        public List<class_3222> trackingPlayers = new ArrayList<class_3222>();
        protected class_243 pos;

        public ScreenShake(float intensity, int duration, int durationFalloffStart, class_243 pos, float maxDistance, int ticks) {
            this.intensity = intensity;
            this.duration = duration;
            this.durationFalloffStart = durationFalloffStart;
            this.pos = pos;
            this.maxDistance = maxDistance;
            this.ticks = ticks;
            this.chunkPos = new class_1923(class_2338.method_49638((class_2374)pos));
        }

        public boolean shouldRemove() {
            return this.ticks > this.duration;
        }

        @Generated
        public int getDuration() {
            return this.duration;
        }

        @Generated
        public float getMaxDistance() {
            return this.maxDistance;
        }

        @Generated
        public float getIntensity() {
            return this.intensity;
        }

        @Generated
        public int getDurationFalloffStart() {
            return this.durationFalloffStart;
        }

        @Generated
        public int getTicks() {
            return this.ticks;
        }

        @Generated
        public class_243 getPos() {
            return this.pos;
        }
    }
}

