/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.personthecat.fresult;

import net.frozenblock.lib.shadow.personthecat.fresult.OptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.PartialOptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.personthecat.fresult.Shorthand;
import net.frozenblock.lib.shadow.personthecat.fresult.Void;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingBiConsumer;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingBiFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingConsumer;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingOptionalBiFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingOptionalFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingSupplier;

public class WithResources<R1 extends AutoCloseable, R2 extends AutoCloseable, E extends Throwable> {
    private final ThrowingSupplier<R1, E> r1Getter;
    private final ThrowingSupplier<R2, E> r2Getter;

    WithResources(ThrowingSupplier<R1, E> r1Getter, ThrowingSupplier<R2, E> r2Getter) {
        this.r1Getter = r1Getter;
        this.r2Getter = r2Getter;
    }

    public <T, E2 extends E> Result.Pending<T, E> of(ThrowingBiFunction<R1, R2, T, E2> attempt) {
        return Result.of(() -> this.execute(attempt));
    }

    public <E2 extends E> Result.Pending<Void, E> of(ThrowingBiConsumer<R1, R2, E2> attempt) {
        return this.of(Result.wrapVoid(attempt));
    }

    public <T, E2 extends E> Result.Pending<T, E> of(ThrowingFunction<R2, T, E2> attempt) {
        return this.of((R1 r1, R2 r2) -> attempt.apply(r2));
    }

    public <E2 extends E> Result.Pending<Void, E> of(ThrowingConsumer<R2, E2> attempt) {
        return this.of((R1 r1, R2 r2) -> attempt.accept(r2));
    }

    public <T, E2 extends E> Result<T, Throwable> suppress(ThrowingBiFunction<R1, R2, T, E2> attempt) {
        return Result.suppress(() -> this.execute(attempt));
    }

    public <E2 extends E> Result<Void, Throwable> suppress(ThrowingBiConsumer<R1, R2, E2> attempt) {
        return this.suppress(Result.wrapVoid(attempt));
    }

    public <T, E2 extends E> Result<T, Throwable> suppress(ThrowingFunction<R2, T, E2> attempt) {
        return this.suppress((R1 r1, R2 r2) -> attempt.apply(r2));
    }

    public <E2 extends E> Result<Void, Throwable> suppress(ThrowingConsumer<R2, E2> attempt) {
        return this.suppress((R1 r1, R2 r2) -> attempt.accept(r2));
    }

    public <T, E2 extends E> PartialOptionalResult<T, E> nullable(ThrowingBiFunction<R1, R2, T, E2> attempt) {
        return Result.nullable(() -> this.execute(attempt));
    }

    public <T, E2 extends E> PartialOptionalResult<T, E> nullable(ThrowingFunction<R2, T, E2> attempt) {
        return this.nullable((R1 r1, R2 r2) -> attempt.apply(r2));
    }

    public <T, E2 extends E> OptionalResult<T, Throwable> suppressNullable(ThrowingBiFunction<R1, R2, T, E2> attempt) {
        return Result.suppressNullable(() -> this.execute(attempt));
    }

    public <T, E2 extends E> OptionalResult<T, Throwable> suppressNullable(ThrowingFunction<R2, T, E2> attempt) {
        return this.suppressNullable((R1 r1, R2 r2) -> attempt.apply(r2));
    }

    public <T, E2 extends E> PartialOptionalResult<T, E> nullable(ThrowingOptionalBiFunction<R1, R2, T, E2> attempt) {
        return this.nullable((R1 r1, R2 r2) -> attempt.apply(r1, r2).orElse(null));
    }

    public <T, E2 extends E> PartialOptionalResult<T, E> nullable(ThrowingOptionalFunction<R2, T, E2> attempt) {
        return this.nullable((R1 r1, R2 r2) -> attempt.apply(r2));
    }

    public <T, E2 extends E> OptionalResult<T, Throwable> suppressNullable(ThrowingOptionalBiFunction<R1, R2, T, E2> attempt) {
        return this.suppressNullable((R1 r1, R2 r2) -> attempt.apply(r1, r2).orElse(null));
    }

    public <T, E2 extends E> OptionalResult<T, Throwable> suppressNullable(ThrowingOptionalFunction<R2, T, E2> attempt) {
        return this.suppressNullable((R1 r1, R2 r2) -> attempt.apply(r2));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T, E2 extends E> T execute(ThrowingBiFunction<R1, R2, T, E2> attempt) throws E {
        try (AutoCloseable r1 = (AutoCloseable)this.r1Getter.get();){
            T t;
            block14: {
                AutoCloseable r2 = (AutoCloseable)this.r2Getter.get();
                try {
                    t = attempt.apply(r1, r2);
                    if (r2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (r2 != null) {
                        try {
                            r2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r2.close();
            }
            return t;
        }
        catch (Throwable e) {
            throw Shorthand.errorFound(e);
        }
    }
}

