/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.structure.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import net.frozenblock.lib.file.nbt.NbtFileUtils;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_6826;
import org.jetbrains.annotations.NotNull;

public class StructureUpgradeCommand {
    private StructureUpgradeCommand() {
    }

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"structure_upgrade").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"namespace", (ArgumentType)StringArgumentType.string()).executes(context -> StructureUpgradeCommand.upgradeAndExportPieces((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"namespace"), false))).then(class_2170.method_9244((String)"log", (ArgumentType)BoolArgumentType.bool()).executes(context -> StructureUpgradeCommand.upgradeAndExportPieces((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"namespace"), BoolArgumentType.getBool((CommandContext)context, (String)"log"))))));
    }

    private static int upgradeAndExportPieces(@NotNull class_2168 source, String namespace, boolean log) {
        class_3300 resourceManager = source.method_9211().method_34864();
        Set foundPieces = resourceManager.method_14488("structure", resourceLocation -> resourceLocation.method_12832().endsWith(".nbt") && resourceLocation.method_12836().equals(namespace)).keySet();
        if (log) {
            foundPieces.forEach(resourceLocation -> System.out.println("Found piece: " + resourceLocation.toString()));
        }
        class_3485 structureTemplateManager = source.method_9225().method_14183();
        Object2ObjectLinkedOpenHashMap savedTemplates = new Object2ObjectLinkedOpenHashMap();
        foundPieces.forEach(arg_0 -> StructureUpgradeCommand.lambda$upgradeAndExportPieces$4(resourceManager, structureTemplateManager, (Map)savedTemplates, arg_0));
        Path outputPath = source.method_9211().method_3831().resolve("upgraded_structure/data_version_" + class_155.method_16673().method_37912().method_38494());
        savedTemplates.forEach((resourceLocation, compoundTag) -> NbtFileUtils.saveToFile(compoundTag, outputPath.resolve(resourceLocation.method_12836()).toFile(), resourceLocation.method_12832().replace(".nbt", "")));
        int templateCount = savedTemplates.size();
        if (templateCount > 0) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.structure_upgrade.success", (Object[])new Object[]{templateCount, namespace}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.structure_upgrade.failure", (Object[])new Object[]{namespace}), true);
        }
        return 1;
    }

    private static /* synthetic */ void lambda$upgradeAndExportPieces$4(class_3300 resourceManager, class_3485 structureTemplateManager, Map savedTemplates, class_2960 resourceLocation) {
        try {
            InputStream inputStream = resourceManager.getResourceOrThrow(resourceLocation).method_14482();
            class_6826 inputStream2 = new class_6826(inputStream);
            class_2487 compoundTag = class_2507.method_10629((InputStream)inputStream2, (class_2505)class_2505.method_53898());
            class_3499 structureTemplate = structureTemplateManager.method_21891(compoundTag);
            inputStream2.close();
            inputStream.close();
            savedTemplates.put(resourceLocation, structureTemplate.method_15175(new class_2487()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

