/*
 * Decompiled with CFR 0.152.
 */
package net.skymoe.enchaddons.impl.feature.awesomemap.features.dungeon;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.skymoe.enchaddons.EnchAddonsKt;
import net.skymoe.enchaddons.feature.awesomemap.AwesomeMap;
import net.skymoe.enchaddons.feature.awesomemap.AwesomeMapConfig;
import net.skymoe.enchaddons.feature.awesomemap.AwesomeMapEvent;
import net.skymoe.enchaddons.impl.feature.awesomemap.features.dungeon.RunInformation;
import net.skymoe.enchaddons.impl.feature.awesomemap.utils.APIUtils;
import net.skymoe.enchaddons.impl.feature.awesomemap.utils.Location;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0006J\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0006J\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0006J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0003R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0017\u0010 \u001a\u00020\u00168F\u00a2\u0006\f\n\u0004\b \u0010\u0018\u001a\u0004\b!\u0010\u001aR\"\u0010\"\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lnet/skymoe/enchaddons/impl/feature/awesomemap/features/dungeon/ScoreCalculation;", "", "<init>", "()V", "", "getBonusScore", "()I", "getDeathDeduction", "getExplorationScore", "", "getSecretPercent", "()F", "getSkillScore", "percentage", "getSpeedDeduction", "(F)F", "timeElapsed", "getSpeedScore", "(I)I", "getTimeLimit", "", "updateScore", "", "message270", "Z", "getMessage270", "()Z", "setMessage270", "(Z)V", "message300", "getMessage300", "setMessage300", "paul", "getPaul", "score", "I", "getScore", "setScore", "(I)V", "EnchAddons-1.8.9-forge"})
public final class ScoreCalculation {
    @NotNull
    public static final ScoreCalculation INSTANCE = new ScoreCalculation();
    private static final boolean paul = APIUtils.INSTANCE.hasBonusPaulScore();
    private static int score;
    private static boolean message300;
    private static boolean message270;

    private ScoreCalculation() {
    }

    public final boolean getPaul() {
        return paul || ((AwesomeMapConfig)AwesomeMap.INSTANCE.getConfig()).getPaulBonus();
    }

    public final int getScore() {
        return score;
    }

    public final void setScore(int n) {
        score = n;
    }

    public final boolean getMessage300() {
        return message300;
    }

    public final void setMessage300(boolean bl) {
        message300 = bl;
    }

    public final boolean getMessage270() {
        return message270;
    }

    public final void setMessage270(boolean bl) {
        message270 = bl;
    }

    public final void updateScore() {
        score = this.getSkillScore() + this.getExplorationScore() + this.getSpeedScore(RunInformation.INSTANCE.getTimeElapsed()) + this.getBonusScore();
        if (score >= 300 && !message300) {
            message300 = true;
            message270 = true;
            AwesomeMapEvent.Score.Reach300 reach300 = new AwesomeMapEvent.Score.Reach300(RunInformation.INSTANCE.getTimeElapsed());
            ((Function1)EnchAddonsKt.getEA().getEventDispatcher()).invoke(reach300);
        } else if (score >= 270 && !message270) {
            message270 = true;
            AwesomeMapEvent.Score.Reach270 reach270 = new AwesomeMapEvent.Score.Reach270(RunInformation.INSTANCE.getTimeElapsed());
            ((Function1)EnchAddonsKt.getEA().getEventDispatcher()).invoke(reach270);
        }
    }

    public final int getSkillScore() {
        int puzzleDeduction = (RunInformation.INSTANCE.getTotalPuzzles() - RunInformation.INSTANCE.getCompletedPuzzles()) * 10;
        float roomPercent = RangesKt.coerceAtMost(RunInformation.INSTANCE.getCompletedRoomsPercentage(), 1.0f);
        return 20 + RangesKt.coerceAtLeast((int)((float)80 * roomPercent) - puzzleDeduction - this.getDeathDeduction(), 0);
    }

    public final int getDeathDeduction() {
        int deathDeduction = RunInformation.INSTANCE.getDeathCount() * 2;
        if (((AwesomeMapConfig)AwesomeMap.INSTANCE.getConfig()).getScoreAssumeSpirit()) {
            --deathDeduction;
        }
        return RangesKt.coerceAtLeast(deathDeduction, 0);
    }

    public final int getExplorationScore() {
        float secretPercent = RangesKt.coerceAtMost(RunInformation.INSTANCE.getSecretPercentage() / this.getSecretPercent(), 1.0f);
        float roomPercent = RangesKt.coerceAtMost(RunInformation.INSTANCE.getCompletedRoomsPercentage(), 1.0f);
        return (int)((float)60 * roomPercent + (float)40 * secretPercent);
    }

    public final int getSpeedScore(int timeElapsed) {
        int score = 100;
        int limit = this.getTimeLimit();
        if (timeElapsed < limit) {
            return score;
        }
        float percentageOver = (float)(timeElapsed - limit) * 100.0f / (float)limit;
        return Location.INSTANCE.getDungeonFloor() == 0 ? MathKt.roundToInt((double)score * 0.7) : (score -= (int)this.getSpeedDeduction(percentageOver));
    }

    public final int getBonusScore() {
        int score = 0;
        score += RangesKt.coerceAtMost(RunInformation.INSTANCE.getCryptsCount(), 5);
        if (RunInformation.INSTANCE.getMimicKilled()) {
            score += 2;
        }
        if (RunInformation.INSTANCE.getPrinceKilled()) {
            ++score;
        }
        if (this.getPaul()) {
            score += 10;
        }
        return score;
    }

    public final float getSecretPercent() {
        float f;
        if (Location.INSTANCE.getMasterMode()) {
            return 1.0f;
        }
        switch (Location.INSTANCE.getDungeonFloor()) {
            case 0: {
                f = 0.3f;
                break;
            }
            case 1: {
                f = 0.3f;
                break;
            }
            case 2: {
                f = 0.4f;
                break;
            }
            case 3: {
                f = 0.5f;
                break;
            }
            case 4: {
                f = 0.6f;
                break;
            }
            case 5: {
                f = 0.7f;
                break;
            }
            case 6: {
                f = 0.85f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        return f;
    }

    private final int getTimeLimit() {
        int n;
        if (Location.INSTANCE.getMasterMode()) {
            switch (Location.INSTANCE.getDungeonFloor()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n = 480;
                    break;
                }
                case 6: {
                    n = 600;
                    break;
                }
                default: {
                    n = 840;
                    break;
                }
            }
        } else {
            switch (Location.INSTANCE.getDungeonFloor()) {
                case 0: {
                    n = 1320;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    n = 600;
                    break;
                }
                case 4: 
                case 6: {
                    n = 720;
                    break;
                }
                default: {
                    n = 840;
                }
            }
        }
        return n;
    }

    private final float getSpeedDeduction(float percentage) {
        float percentageOver = percentage;
        float deduction = 0.0f;
        deduction += RangesKt.coerceAtMost(percentageOver, 20.0f) / 2.0f;
        if ((percentageOver -= 20.0f) <= 0.0f) {
            return deduction;
        }
        deduction += RangesKt.coerceAtMost(percentageOver, 20.0f) / 3.5f;
        if ((percentageOver -= 20.0f) <= 0.0f) {
            return deduction;
        }
        deduction += RangesKt.coerceAtMost(percentageOver, 10.0f) / 4.0f;
        if ((percentageOver -= 10.0f) <= 0.0f) {
            return deduction;
        }
        deduction += RangesKt.coerceAtMost(percentageOver, 10.0f) / 5.0f;
        if ((percentageOver -= 10.0f) <= 0.0f) {
            return deduction;
        }
        return deduction += percentageOver / 6.0f;
    }
}

