/*
 * Decompiled with CFR 0.152.
 */
package net.skymoe.enchaddons.util;

import java.awt.Color;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u000e\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0007\u001a\u00020\u00002\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\t\u001a\u00020\u00002\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\b\u001a\u0019\u0010\n\u001a\u00020\u00002\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\b\u001a\u0019\u0010\f\u001a\u00020\u00022\n\u0010\u000b\u001a\u00020\u0002\"\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0004\u001a\u0019\u0010\u000f\u001a\u00020\u00022\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\r\u001a\u001c\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0086\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001c\u0010\u0011\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0014\u001a\u0014\u0010\u0016\u001a\u00020\u0000*\u00020\u0015H\u0086\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0014\u0010\u0018\u001a\u00020\u0000*\u00020\u0015H\u0086\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017\u001a\u0014\u0010\u0019\u001a\u00020\u0000*\u00020\u0015H\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017\u001a\u0014\u0010\u001a\u001a\u00020\u0000*\u00020\u0015H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0017\u001a\u0011\u0010\u001b\u001a\u00020\u0015*\u00020\u0015\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0019\u0010\u001f\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0019\u0010\u001f\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010!\"\u0014\u0010\"\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010#\"\u0014\u0010$\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010#\"\u0014\u0010%\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010#\"\u0014\u0010&\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010#\"\u0014\u0010'\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010#\"\u0014\u0010(\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010#\"\u0016\u0010*\u001a\u00020\u0002*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b)\u0010\r\u00a8\u0006+"}, d2={"", "argb", "", "convertARGBToDoubleArray", "(I)[D", "", "rgb", "convertDoubleArrayToARGB", "([D)I", "convertDoubleArrayToFFRGB", "convertDoubleArrayToRGB", "hsl", "convertHSLToRGB", "([D)[D", "convertRGBToDoubleArray", "convertRGBToHSL", "rgbaSrc", "blendColor", "([D[D)[D", "argbSrc", "(II)I", "Ljava/awt/Color;", "component1", "(Ljava/awt/Color;)I", "component2", "component3", "component4", "invisible", "(Ljava/awt/Color;)Ljava/awt/Color;", "", "alpha", "withAlpha", "(Ljava/awt/Color;F)Ljava/awt/Color;", "(Ljava/awt/Color;I)Ljava/awt/Color;", "V06", "D", "V16", "V26", "V36", "V46", "V56", "getNormalizeColor", "normalizeColor", "EnchAddons-1.8.9-forge"})
@SourceDebugExtension(value={"SMAP\nColorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorUtil.kt\nnet/skymoe/enchaddons/util/ColorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MathUtil.kt\nnet/skymoe/enchaddons/util/math/MathUtilKt\n*L\n1#1,118:1\n97#1:120\n97#1:121\n97#1:122\n97#1:124\n97#1:129\n1#2:119\n10#3:123\n10#3:125\n10#3:126\n10#3:127\n10#3:128\n*S KotlinDebug\n*F\n+ 1 ColorUtil.kt\nnet/skymoe/enchaddons/util/ColorUtilKt\n*L\n42#1:120\n72#1:121\n81#1:122\n86#1:124\n111#1:129\n83#1:123\n87#1:125\n88#1:126\n89#1:127\n90#1:128\n*E\n"})
public final class ColorUtilKt {
    private static final double V06 = 0.0;
    private static final double V16 = 0.16666666666666666;
    private static final double V26 = 0.3333333333333333;
    private static final double V36 = 0.5;
    private static final double V46 = 0.6666666666666666;
    private static final double V56 = 0.8333333333333334;

    @NotNull
    public static final Color withAlpha(@NotNull Color $this$withAlpha, int alpha) {
        Intrinsics.checkNotNullParameter($this$withAlpha, "<this>");
        return new Color($this$withAlpha.getRed(), $this$withAlpha.getGreen(), $this$withAlpha.getBlue(), alpha);
    }

    @NotNull
    public static final Color withAlpha(@NotNull Color $this$withAlpha, float alpha) {
        Intrinsics.checkNotNullParameter($this$withAlpha, "<this>");
        return new Color($this$withAlpha.getRed(), $this$withAlpha.getGreen(), $this$withAlpha.getBlue(), (int)(alpha * (float)255));
    }

    @NotNull
    public static final Color invisible(@NotNull Color $this$invisible) {
        Intrinsics.checkNotNullParameter($this$invisible, "<this>");
        return ColorUtilKt.withAlpha($this$invisible, 0);
    }

    public static final int component1(@NotNull Color $this$component1) {
        Intrinsics.checkNotNullParameter($this$component1, "<this>");
        return $this$component1.getRed();
    }

    public static final int component2(@NotNull Color $this$component2) {
        Intrinsics.checkNotNullParameter($this$component2, "<this>");
        return $this$component2.getGreen();
    }

    public static final int component3(@NotNull Color $this$component3) {
        Intrinsics.checkNotNullParameter($this$component3, "<this>");
        return $this$component3.getBlue();
    }

    public static final int component4(@NotNull Color $this$component4) {
        Intrinsics.checkNotNullParameter($this$component4, "<this>");
        return $this$component4.getAlpha();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] convertRGBToHSL(double ... rgb) {
        Intrinsics.checkNotNullParameter(rgb, "rgb");
        double[] hsl = new double[rgb.length >= 4 ? 4 : 3];
        double maxRGB = ComparisonsKt.maxOf(0.0, Arrays.copyOf(rgb, rgb.length));
        double minRGB = ComparisonsKt.minOf(1.0, Arrays.copyOf(rgb, rgb.length));
        double delta = maxRGB - minRGB;
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        hsl[2] = (maxRGB + minRGB) / 2.0;
        if (delta > 0.0) {
            void it;
            hsl[1] = delta / Math.min(maxRGB + minRGB, (double)2 - maxRGB - minRGB);
            double d = maxRGB;
            double d2 = d == r ? (g - b) / delta + 6.0 : (d == g ? (b - r) / delta + 2.0 : (d == b ? (r - g) / delta + 4.0 : 0.0));
            int n = 0;
            double[] dArray = hsl;
            boolean bl = false;
            void var23_15 = it / 6.0 % 1.0;
            dArray[n] = var23_15;
        }
        if (rgb.length >= 4) {
            hsl[3] = rgb[3];
        }
        double[] $this$normalizeColor$iv = hsl;
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = $this$normalizeColor$iv.length;
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv[n3]));
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] convertHSLToRGB(double ... hsl) {
        void $this$normalizeColor$iv;
        double[] dArray;
        double[] dArray2;
        Intrinsics.checkNotNullParameter(hsl, "hsl");
        double h = hsl[0];
        double s = hsl[1];
        double l = hsl[2];
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double x = c * (1.0 - Math.abs(h * 6.0 % 2.0 - 1.0));
        double m = l - c / 2.0;
        double d = h;
        Triple<Double, Double, Double> triple = RangesKt.rangeUntil(0.0, 0.16666666666666666).contains((Double)((Comparable)Double.valueOf(d))) ? new Triple<Double, Double, Double>(c, x, 0.0) : (RangesKt.rangeUntil(0.16666666666666666, 0.3333333333333333).contains((Double)((Comparable)Double.valueOf(d))) ? new Triple<Double, Double, Double>(x, c, 0.0) : (RangesKt.rangeUntil(0.3333333333333333, 0.5).contains((Double)((Comparable)Double.valueOf(d))) ? new Triple<Double, Double, Double>(0.0, c, x) : (RangesKt.rangeUntil(0.5, 0.6666666666666666).contains((Double)((Comparable)Double.valueOf(d))) ? new Triple<Double, Double, Double>(0.0, x, c) : (RangesKt.rangeUntil(0.6666666666666666, 0.8333333333333334).contains((Double)((Comparable)Double.valueOf(d))) ? new Triple<Double, Double, Double>(x, 0.0, c) : new Triple<Double, Double, Double>(c, 0.0, x)))));
        double rp = ((Number)triple.component1()).doubleValue();
        double gp = ((Number)triple.component2()).doubleValue();
        double bp = ((Number)triple.component3()).doubleValue();
        if (hsl.length >= 4) {
            dArray2 = new double[]{rp + m, gp + m, bp + m, hsl[3]};
            dArray = dArray2;
        } else {
            dArray2 = new double[]{rp + m, gp + m, bp + m};
            dArray = dArray2;
        }
        dArray2 = dArray;
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = ((void)$this$normalizeColor$iv).length;
        double[] dArray3 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray3[n3] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv[n3]));
        }
        return dArray3;
    }

    @NotNull
    public static final double[] convertARGBToDoubleArray(int argb) {
        double[] dArray = new double[]{(double)(argb >>> 16 & 0xFF) / 255.0, (double)(argb >>> 8 & 0xFF) / 255.0, (double)(argb & 0xFF) / 255.0, (double)(argb >>> 24 & 0xFF) / 255.0};
        double[] $this$normalizeColor$iv = dArray;
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = $this$normalizeColor$iv.length;
        double[] dArray2 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray2[n3] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv[n3]));
        }
        return dArray2;
    }

    @NotNull
    public static final double[] convertRGBToDoubleArray(int argb) {
        long $this$int$iv = 0xFF000000L;
        boolean $i$f$getInt = false;
        return ColorUtilKt.convertARGBToDoubleArray(argb | (int)$this$int$iv);
    }

    public static final int convertDoubleArrayToARGB(double ... rgb) {
        int n;
        Intrinsics.checkNotNullParameter(rgb, "rgb");
        double[] $this$normalizeColor$iv = rgb;
        boolean $i$f$getNormalizeColor = false;
        int n2 = 0;
        int n3 = $this$normalizeColor$iv.length;
        double[] dArray = new double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dArray[n4] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv[n4]));
        }
        double[] norm = dArray;
        double $this$int$iv = norm[0] * 255.0;
        boolean $i$f$getInt = false;
        int n5 = (int)$this$int$iv << 16;
        $this$int$iv = norm[1] * 255.0;
        $i$f$getInt = false;
        int n6 = n5 | (int)$this$int$iv << 8;
        $this$int$iv = norm[2] * 255.0;
        $i$f$getInt = false;
        int n7 = n6 | (int)$this$int$iv;
        if (rgb.length >= 4) {
            $this$int$iv = norm[3] * 255.0;
            $i$f$getInt = false;
            n = (int)$this$int$iv << 24;
        } else {
            n = 255;
        }
        return n7 | n;
    }

    public static final int convertDoubleArrayToRGB(double ... rgb) {
        Intrinsics.checkNotNullParameter(rgb, "rgb");
        double[] dArray = new double[]{rgb[0], rgb[1], rgb[2], 0.0};
        return ColorUtilKt.convertDoubleArrayToARGB(dArray);
    }

    public static final int convertDoubleArrayToFFRGB(double ... rgb) {
        Intrinsics.checkNotNullParameter(rgb, "rgb");
        double[] dArray = new double[]{rgb[0], rgb[1], rgb[2], 1.0};
        return ColorUtilKt.convertDoubleArrayToARGB(dArray);
    }

    @NotNull
    public static final double[] getNormalizeColor(@NotNull double[] $this$normalizeColor) {
        Intrinsics.checkNotNullParameter($this$normalizeColor, "<this>");
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = $this$normalizeColor.length;
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = Math.max(0.0, Math.min(1.0, $this$normalizeColor[n3]));
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] blendColor(@NotNull double[] $this$blendColor, @NotNull double[] rgbaSrc) {
        void $this$normalizeColor$iv;
        Intrinsics.checkNotNullParameter($this$blendColor, "<this>");
        Intrinsics.checkNotNullParameter(rgbaSrc, "rgbaSrc");
        double srcR = rgbaSrc[0];
        double srcG = rgbaSrc[1];
        double srcB = rgbaSrc[2];
        double srcA = rgbaSrc[3];
        double dstR = $this$blendColor[0];
        double dstG = $this$blendColor[1];
        double dstB = $this$blendColor[2];
        double dstA = $this$blendColor.length >= 4 ? $this$blendColor[3] : 1.0;
        double resA = srcA + dstA * (1.0 - srcA);
        double srcM = srcA / resA;
        double dstM = dstA * (1.0 - srcA) / resA;
        double[] dArray = new double[]{srcR * srcM + dstR * dstM, srcG * srcM + dstG * dstM, srcB * srcM + dstB * dstM, resA};
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = ((void)$this$normalizeColor$iv).length;
        double[] dArray2 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray2[n3] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv[n3]));
        }
        return dArray2;
    }

    public static final int blendColor(int $this$blendColor, int argbSrc) {
        double[] dArray = ColorUtilKt.blendColor(ColorUtilKt.convertARGBToDoubleArray($this$blendColor), ColorUtilKt.convertARGBToDoubleArray(argbSrc));
        return ColorUtilKt.convertDoubleArrayToARGB(Arrays.copyOf(dArray, dArray.length));
    }
}

