/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.IOException;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/cache2/FileOperator;", "", "Ljava/nio/channels/FileChannel;", "fileChannel", "<init>", "(Ljava/nio/channels/FileChannel;)V", "", "pos", "Lokio/Buffer;", "sink", "byteCount", "", "read", "(JLokio/Buffer;J)V", "source", "write", "Ljava/nio/channels/FileChannel;", "okhttp"})
public final class FileOperator {
    @NotNull
    private final FileChannel fileChannel;

    public FileOperator(@NotNull FileChannel fileChannel) {
        Intrinsics.checkNotNullParameter(fileChannel, "fileChannel");
        this.fileChannel = fileChannel;
    }

    public final void write(long pos, @NotNull Buffer source2, long byteCount) throws IOException {
        long bytesWritten;
        Intrinsics.checkNotNullParameter(source2, "source");
        if (byteCount < 0L || byteCount > source2.size()) {
            throw new IndexOutOfBoundsException();
        }
        long mutablePos = pos;
        for (long mutableByteCount = byteCount; mutableByteCount > 0L; mutableByteCount -= bytesWritten) {
            bytesWritten = this.fileChannel.transferFrom(source2, mutablePos, mutableByteCount);
            mutablePos += bytesWritten;
        }
    }

    public final void read(long pos, @NotNull Buffer sink2, long byteCount) {
        long bytesRead;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        if (byteCount < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long mutablePos = pos;
        for (long mutableByteCount = byteCount; mutableByteCount > 0L; mutableByteCount -= bytesRead) {
            bytesRead = this.fileChannel.transferTo(mutablePos, mutableByteCount, sink2);
            mutablePos += bytesRead;
        }
    }
}

