/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u001f\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/platform/android/AndroidLog;", "", "<init>", "()V", "", "loggerName", "", "logLevel", "message", "", "t", "", "androidLog$okhttp", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Throwable;)V", "androidLog", "enable", "logger", "tag", "enableLogging", "(Ljava/lang/String;Ljava/lang/String;)V", "loggerTag", "(Ljava/lang/String;)Ljava/lang/String;", "MAX_LOG_LENGTH", "I", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/logging/Logger;", "configuredLoggers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "knownLoggers", "Ljava/util/Map;", "okhttp"})
@SuppressSignatureCheck
public final class AndroidLog {
    @NotNull
    public static final AndroidLog INSTANCE;
    private static final int MAX_LOG_LENGTH = 4000;
    @NotNull
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    @NotNull
    private static final Map<String, String> knownLoggers;

    private AndroidLog() {
    }

    public final void androidLog$okhttp(@NotNull String loggerName, int logLevel, @NotNull String message2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter(loggerName, "loggerName");
        Intrinsics.checkNotNullParameter(message2, "message");
        String tag = this.loggerTag(loggerName);
        if (Log.isLoggable((String)tag, (int)logLevel)) {
            String logMessage = message2;
            if (t != null) {
                logMessage = logMessage + '\n' + Log.getStackTraceString((Throwable)t);
            }
            int length = logMessage.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)logMessage, '\n', i, false, 4, null);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i + 4000);
                    String string = logMessage.substring(i, end);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Log.println((int)logLevel, (String)tag, (String)string);
                } while ((i = end) < newline);
            }
        }
    }

    private final String loggerTag(String loggerName) {
        String string = knownLoggers.get(loggerName);
        if (string == null) {
            string = StringsKt.take(loggerName, 23);
        }
        return string;
    }

    public final void enable() {
        for (Map.Entry<String, String> entry : knownLoggers.entrySet()) {
            String logger = entry.getKey();
            String tag = entry.getValue();
            this.enableLogging(logger, tag);
        }
    }

    private final void enableLogging(String logger, String tag) {
        Logger logger2 = Logger.getLogger(logger);
        if (configuredLoggers.add(logger2)) {
            logger2.setUseParentHandlers(false);
            logger2.setLevel(Log.isLoggable((String)tag, (int)3) ? Level.FINE : (Log.isLoggable((String)tag, (int)4) ? Level.INFO : Level.WARNING));
            logger2.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    static {
        String packageName;
        LinkedHashMap linkedHashMap;
        INSTANCE = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap $this$knownLoggers_u24lambda_u240 = linkedHashMap = new LinkedHashMap();
        boolean bl = false;
        Package package_ = OkHttpClient.class.getPackage();
        String string = packageName = package_ != null ? package_.getName() : null;
        if (packageName != null) {
            ((Map)$this$knownLoggers_u24lambda_u240).put(packageName, "OkHttp");
        }
        Map map = $this$knownLoggers_u24lambda_u240;
        String string2 = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "OkHttpClient::class.java.name");
        String string3 = string2;
        String string4 = "okhttp.OkHttpClient";
        map.put(string3, string4);
        map = $this$knownLoggers_u24lambda_u240;
        String string5 = Http2.class.getName();
        Intrinsics.checkNotNullExpressionValue(string5, "Http2::class.java.name");
        string3 = string5;
        string4 = "okhttp.Http2";
        map.put(string3, string4);
        map = $this$knownLoggers_u24lambda_u240;
        String string6 = TaskRunner.class.getName();
        Intrinsics.checkNotNullExpressionValue(string6, "TaskRunner::class.java.name");
        string3 = string6;
        string4 = "okhttp.TaskRunner";
        map.put(string3, string4);
        ((Map)$this$knownLoggers_u24lambda_u240).put("okhttp3.mockwebserver.MockWebServer", "okhttp.MockWebServer");
        knownLoggers = MapsKt.toMap(linkedHashMap);
    }
}

