/*
 * Decompiled with CFR 0.152.
 */
package net.skymoe.enchaddons.impl.feature.awesomemap.core.map;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.skymoe.enchaddons.impl.config.EnchAddonsConfig;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.DoorType;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.RoomState;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Tile;
import net.skymoe.enchaddons.impl.feature.awesomemap.features.dungeon.MapRender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b#\u0010\"\u00a8\u0006$"}, d2={"Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Door;", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Tile;", "", "x", "z", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/DoorType;", "type", "<init>", "(IILnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/DoorType;)V", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "color", "", "opened", "Z", "getOpened", "()Z", "setOpened", "(Z)V", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/RoomState;", "state", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/RoomState;", "getState", "()Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/RoomState;", "setState", "(Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/RoomState;)V", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/DoorType;", "getType", "()Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/DoorType;", "setType", "(Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/DoorType;)V", "I", "getX", "()I", "getZ", "EnchAddons-1.8.9-forge"})
public final class Door
implements Tile {
    private final int x;
    private final int z;
    @NotNull
    private DoorType type;
    private boolean opened;
    @NotNull
    private RoomState state;

    public Door(int x, int z, @NotNull DoorType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.x = x;
        this.z = z;
        this.type = type;
        this.state = RoomState.UNDISCOVERED;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @NotNull
    public final DoorType getType() {
        return this.type;
    }

    public final void setType(@NotNull DoorType doorType) {
        Intrinsics.checkNotNullParameter((Object)doorType, "<set-?>");
        this.type = doorType;
    }

    public final boolean getOpened() {
        return this.opened;
    }

    public final void setOpened(boolean bl) {
        this.opened = bl;
    }

    @Override
    @NotNull
    public RoomState getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull RoomState roomState) {
        Intrinsics.checkNotNullParameter((Object)roomState, "<set-?>");
        this.state = roomState;
    }

    @Override
    @NotNull
    public Color getColor() {
        Color color;
        if (MapRender.INSTANCE.getLegitRender() && this.getState() == RoomState.UNOPENED) {
            Color color2 = EnchAddonsConfig.INSTANCE.getDungeonConfig().getAwesomeMapConfig().getColorUnopenedDoor().toJavaColor();
            Intrinsics.checkNotNull(color2);
            color = color2;
        } else {
            Color color3;
            switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1: {
                    color3 = EnchAddonsConfig.INSTANCE.getDungeonConfig().getAwesomeMapConfig().getColorBloodDoor().toJavaColor();
                    break;
                }
                case 2: {
                    color3 = EnchAddonsConfig.INSTANCE.getDungeonConfig().getAwesomeMapConfig().getColorEntranceDoor().toJavaColor();
                    break;
                }
                case 3: {
                    if (this.opened) {
                        color3 = EnchAddonsConfig.INSTANCE.getDungeonConfig().getAwesomeMapConfig().getColorOpenWitherDoor().toJavaColor();
                        break;
                    }
                    color3 = EnchAddonsConfig.INSTANCE.getDungeonConfig().getAwesomeMapConfig().getColorWitherDoor().toJavaColor();
                    break;
                }
                default: {
                    color3 = EnchAddonsConfig.INSTANCE.getDungeonConfig().getAwesomeMapConfig().getColorRoomDoor().toJavaColor();
                }
            }
            Color color4 = color3;
            Intrinsics.checkNotNull(color4);
            color = color4;
        }
        return color;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DoorType.values().length];
            try {
                nArray[DoorType.BLOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoorType.ENTRANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoorType.WITHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

