/*
 * Decompiled with CFR 0.152.
 */
package net.skymoe.enchaddons.impl.feature.awesomemap.features.dungeon;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.RoomData;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Door;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.DoorType;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Room;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.RoomState;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.RoomType;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Tile;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Unknown;
import net.skymoe.enchaddons.impl.feature.awesomemap.utils.MapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lnet/skymoe/enchaddons/impl/feature/awesomemap/features/dungeon/DungeonMap;", "", "", "mapColors", "<init>", "([B)V", "", "arrayX", "arrayY", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Tile;", "getTile", "(II)Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Tile;", "worldX", "worldZ", "scanTile", "(IIII)Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Tile;", "", "cacheTiles", "[Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Tile;", "centerColors", "[B", "sideColors", "EnchAddons-1.8.9-forge"})
public final class DungeonMap {
    @NotNull
    private byte[] centerColors;
    @NotNull
    private byte[] sideColors;
    @NotNull
    private final Tile[] cacheTiles;

    public DungeonMap(@NotNull byte[] mapColors) {
        Intrinsics.checkNotNullParameter(mapColors, "mapColors");
        this.centerColors = new byte[121];
        this.sideColors = new byte[121];
        int n = 0;
        Tile[] tileArray = new Tile[121];
        DungeonMap dungeonMap = this;
        while (n < 121) {
            int n2 = n++;
            tileArray[n2] = null;
        }
        dungeonMap.cacheTiles = tileArray;
        int halfRoom = MapUtils.INSTANCE.getRoomSize() / 2;
        int halfTile = halfRoom + 2;
        int startX = ((Number)MapUtils.INSTANCE.getStartCorner().getFirst()).intValue() + halfRoom;
        int startY = ((Number)MapUtils.INSTANCE.getStartCorner().getSecond()).intValue() + halfRoom;
        for (int y = 0; y < 11; ++y) {
            for (int x = 0; x < 11; ++x) {
                int n3;
                int mapX = startX + x * halfTile;
                int mapY = startY + y * halfTile;
                if (mapX >= 128 || mapY >= 128) continue;
                this.centerColors[y * 11 + x] = mapColors[mapY * 128 + mapX];
                if (x % 2 == 0 && y % 2 == 0) {
                    int topX = mapX - halfRoom;
                    int topY = mapY - halfRoom;
                    n3 = topY * 128 + topX;
                } else {
                    boolean horizontal = y % 2 == 1;
                    n3 = horizontal ? mapY * 128 + mapX - 4 : (mapY - 4) * 128 + mapX;
                }
                int sideIndex = n3;
                this.sideColors[y * 11 + x] = mapColors[sideIndex];
            }
        }
    }

    @NotNull
    public final Tile getTile(int arrayX, int arrayY) {
        Tile tile;
        int index = arrayY * 11 + arrayX;
        if (!(0 <= index ? index < this.cacheTiles.length : false)) {
            return new Unknown(0, 0);
        }
        if (this.cacheTiles[index] == null) {
            int xPos = -185 + arrayX * 16;
            int zPos = -185 + arrayY * 16;
            this.cacheTiles[index] = this.scanTile(arrayX, arrayY, xPos, zPos);
        }
        if ((tile = this.cacheTiles[index]) == null) {
            tile = new Unknown(0, 0);
        }
        return tile;
    }

    private final Tile scanTile(int arrayX, int arrayY, int worldX, int worldZ) {
        Tile tile;
        byte centerColor = this.centerColors[arrayY * 11 + arrayX];
        byte sideColor = this.sideColors[arrayY * 11 + arrayX];
        if (centerColor == 0) {
            return new Unknown(worldX, worldZ);
        }
        if (arrayX % 2 == 0 && arrayY % 2 == 0) {
            RoomState roomState;
            Room room;
            RoomType roomType = RoomType.Companion.fromMapColor(sideColor);
            if (roomType == null) {
                return new Unknown(worldX, worldZ);
            }
            RoomType type = roomType;
            Room $this$scanTile_u24lambda_u240 = room = new Room(worldX, worldZ, RoomData.Companion.createUnknown(type));
            boolean bl = false;
            block0 : switch (centerColor) {
                case 18: {
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            roomState = RoomState.DISCOVERED;
                            break block0;
                        }
                        case 2: {
                            roomState = RoomState.FAILED;
                            break block0;
                        }
                    }
                    roomState = $this$scanTile_u24lambda_u240.getState();
                    break;
                }
                case 30: {
                    if (WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 3) {
                        roomState = RoomState.DISCOVERED;
                        break;
                    }
                    roomState = RoomState.GREEN;
                    break;
                }
                case 34: {
                    roomState = RoomState.CLEARED;
                    break;
                }
                case 85: 
                case 119: {
                    roomState = RoomState.UNOPENED;
                    break;
                }
                default: {
                    roomState = RoomState.DISCOVERED;
                }
            }
            $this$scanTile_u24lambda_u240.setState(roomState);
            tile = room;
        } else if (sideColor == 0) {
            Door door;
            DoorType doorType = DoorType.Companion.fromMapColor(centerColor);
            if (doorType == null) {
                return new Unknown(worldX, worldZ);
            }
            DoorType type = doorType;
            Door $this$scanTile_u24lambda_u241 = door = new Door(worldX, worldZ, type);
            boolean bl = false;
            $this$scanTile_u24lambda_u241.setState(centerColor == 85 ? RoomState.UNOPENED : RoomState.DISCOVERED);
            tile = door;
        } else {
            Room room;
            RoomType roomType = RoomType.Companion.fromMapColor(sideColor);
            if (roomType == null) {
                return new Unknown(worldX, worldZ);
            }
            RoomType type = roomType;
            Room $this$scanTile_u24lambda_u242 = room = new Room(worldX, worldZ, RoomData.Companion.createUnknown(type));
            boolean bl = false;
            $this$scanTile_u24lambda_u242.setState(RoomState.DISCOVERED);
            $this$scanTile_u24lambda_u242.setSeparator(true);
            tile = room;
        }
        return tile;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoomType.values().length];
            try {
                nArray[RoomType.BLOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.PUZZLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.ENTRANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

