/*
 * Decompiled with CFR 0.152.
 */
package net.skymoe.enchaddons.impl.feature.awesomemap.features.dungeon;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.net.URL;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.RoomData;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Room;
import net.skymoe.enchaddons.impl.feature.awesomemap.core.map.Tile;
import net.skymoe.enchaddons.impl.feature.awesomemap.features.dungeon.Dungeon;
import net.skymoe.enchaddons.impl.feature.awesomemap.utils.Utils;
import net.skymoe.enchaddons.util.MinecraftUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lnet/skymoe/enchaddons/impl/feature/awesomemap/features/dungeon/ScanUtils;", "", "<init>", "()V", "", "x", "z", "getCore", "(II)I", "posX", "posZ", "Lkotlin/Pair;", "getRoomCentre", "(II)Lkotlin/Pair;", "hash", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/RoomData;", "getRoomData", "(I)Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/RoomData;", "(II)Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/RoomData;", "Lnet/minecraft/util/BlockPos;", "pos", "Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Room;", "getRoomFromPos", "(Lnet/minecraft/util/BlockPos;)Lnet/skymoe/enchaddons/impl/feature/awesomemap/core/map/Room;", "", "roomList", "Ljava/util/Set;", "getRoomList", "()Ljava/util/Set;", "EnchAddons-1.8.9-forge"})
@SourceDebugExtension(value={"SMAP\nScanUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanUtils.kt\nnet/skymoe/enchaddons/impl/feature/awesomemap/features/dungeon/ScanUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class ScanUtils {
    @NotNull
    public static final ScanUtils INSTANCE;
    @NotNull
    private static final Set<RoomData> roomList;

    private ScanUtils() {
    }

    @NotNull
    public final Set<RoomData> getRoomList() {
        return roomList;
    }

    @Nullable
    public final RoomData getRoomData(int x, int z) {
        return this.getRoomData(this.getCore(x, z));
    }

    @Nullable
    public final RoomData getRoomData(int hash) {
        Object v0;
        block1: {
            Iterable iterable = roomList;
            for (Object t : iterable) {
                RoomData it = (RoomData)t;
                boolean bl = false;
                if (!it.getCores().contains(hash)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Pair<Integer, Integer> getRoomCentre(int posX, int posZ) {
        int roomX = MathKt.roundToInt((float)(posX - -185) / 32.0f);
        int roomZ = MathKt.roundToInt((float)(posZ - -185) / 32.0f);
        return new Pair<Integer, Integer>(roomX * 32 + -185, roomZ * 32 + -185);
    }

    @Nullable
    public final Room getRoomFromPos(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        int x = pos.func_177958_n() - -185 + 15 >> 5;
        int z = pos.func_177952_p() - -185 + 15 >> 5;
        Tile room = ArraysKt.getOrNull(Dungeon.Info.INSTANCE.getDungeonList(), x * 2 + z * 22);
        return room instanceof Room ? (Room)room : null;
    }

    public final int getCore(int x, int z) {
        StringBuilder sb = new StringBuilder(150);
        Chunk chunk = MinecraftUtilKt.getMC().field_71441_e.func_72964_e(x >> 4, z >> 4);
        int height = RangesKt.coerceIn(chunk.func_76611_b(x & 0xF, z & 0xF), new IntRange(11, 140));
        int n = 0;
        int n2 = 140 - height;
        char[] cArray = new char[n2];
        StringBuilder stringBuilder = sb;
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = 48;
        }
        stringBuilder.append(cArray);
        int bedrock = 0;
        for (int y = height; 11 < y; --y) {
            int id = Block.func_149682_b((Block)chunk.func_177428_a(new BlockPos(x, y, z)));
            if (id == 0 && bedrock >= 2 && y < 69) {
                int n4 = 0;
                int n5 = y - 11;
                char[] cArray2 = new char[n5];
                stringBuilder = sb;
                while (n4 < n5) {
                    int n6 = n4++;
                    cArray2[n6] = 48;
                }
                stringBuilder.append(cArray2);
                break;
            }
            if (id == 7) {
                ++bedrock;
            } else {
                bedrock = 0;
                Object[] objectArray = new Object[]{5, 54, 146};
                if (Utils.INSTANCE.equalsOneOf(id, objectArray)) continue;
            }
            sb.append(id);
        }
        return sb.toString().hashCode();
    }

    static {
        Object object;
        INSTANCE = new ScanUtils();
        try {
            Gson gson = new Gson();
            URL uRL = INSTANCE.getClass().getResource("/assets/enchaddons/awesomemap/rooms.json");
            Intrinsics.checkNotNull(uRL);
            object = gson.fromJson(new String(TextStreamsKt.readBytes(uRL), Charsets.UTF_8), new TypeToken<Set<? extends RoomData>>(){}.getType());
            Intrinsics.checkNotNull(object);
            object = (Set)object;
        }
        catch (JsonSyntaxException e) {
            System.out.println((Object)"Error parsing FunnyMap room data.");
            object = SetsKt.emptySet();
        }
        catch (JsonIOException e) {
            System.out.println((Object)"Error reading FunnyMap room data.");
            object = SetsKt.emptySet();
        }
        roomList = object;
    }
}

