/*
 * Decompiled with CFR 0.152.
 */
package io.github.derec4.guests;

import io.github.derec4.guests.listeners.GuestBlockListener;
import io.github.derec4.guests.listeners.GuestChatListener;
import io.github.derec4.guests.listeners.GuestJoinListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Guests
extends JavaPlugin {
    private String discordInviteUrl;
    private String guestWelcomeMessage;
    private String guestChatDenyMessage;
    private boolean forceSpectator;
    private boolean allowGuestBreakBlocks;
    private boolean allowGuestPlaceBlocks;
    private boolean allowGuestInteract;
    private boolean allowGuestChat;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.discordInviteUrl = config.getString("discordInviteUrl", "https://discord.gg/example");
        this.guestWelcomeMessage = config.getString("guestWelcomeMessage", "\u00a7eWelcome! You are a guest.");
        this.guestChatDenyMessage = config.getString("guestChatDenyMessage", "\u00a7cYou are a guest.");
        this.forceSpectator = config.getBoolean("forceSpectator", true);
        this.allowGuestBreakBlocks = config.getBoolean("allowGuestBreakBlocks", false);
        this.allowGuestPlaceBlocks = config.getBoolean("allowGuestPlaceBlocks", false);
        this.allowGuestInteract = config.getBoolean("allowGuestInteract", false);
        this.allowGuestChat = config.getBoolean("allowGuestChat", false);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new GuestJoinListener(this), (Plugin)this);
        pm.registerEvents((Listener)new GuestChatListener(this), (Plugin)this);
        pm.registerEvents((Listener)new GuestBlockListener(this), (Plugin)this);
        Bukkit.getLogger().info("");
        Bukkit.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "  |_______|                               ");
        Bukkit.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "  | Derex |     Guests v" + this.getDescription().getVersion());
        Bukkit.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "  |_______|     Running on " + Bukkit.getName() + " - " + Bukkit.getVersion());
        Bukkit.getLogger().info("");
    }

    public String getDiscordInviteUrl() {
        return this.discordInviteUrl;
    }

    public String getGuestWelcomeMessage() {
        return this.guestWelcomeMessage;
    }

    public String getGuestChatDenyMessage() {
        return this.guestChatDenyMessage;
    }

    public boolean isForceSpectator() {
        return this.forceSpectator;
    }

    public boolean canGuestBreakBlocks() {
        return this.allowGuestBreakBlocks;
    }

    public boolean canGuestPlaceBlocks() {
        return this.allowGuestPlaceBlocks;
    }

    public boolean canGuestInteract() {
        return this.allowGuestInteract;
    }

    public boolean canGuestChat() {
        return this.allowGuestChat;
    }

    public void onDisable() {
    }
}

