/*
 * Decompiled with CFR 0.152.
 */
package io.github.derec4.guests.listeners;

import io.github.derec4.guests.Guests;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class GuestBlockListener
implements Listener {
    private final Guests plugin;

    public GuestBlockListener(Guests plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("guests.guest") && !this.plugin.canGuestBreakBlocks()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("guests.guest") && !this.plugin.canGuestPlaceBlocks()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player != null && player.hasPermission("guests.guest") && !this.plugin.canGuestInteract()) {
            event.setCancelled(true);
        }
    }
}

