/*
 * Decompiled with CFR 0.152.
 */
package io.github.derec4.guests.listeners;

import io.github.derec4.guests.Guests;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class GuestJoinListener
implements Listener {
    private final Guests plugin;

    public GuestJoinListener(Guests plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("guests.guest")) {
            String message = this.plugin.getGuestWelcomeMessage();
            player.sendMessage(message);
            if (this.plugin.isForceSpectator() && player.hasPermission("guests.spectator")) {
                Bukkit.getLogger().info("[Guests] Detected guest with 'guests.spectator' permission. Forcing spectator mode for: " + player.getName());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.setGameMode(GameMode.SPECTATOR), 1L);
            }
        } else {
            String[] ignoreGroups = new String[]{"jailed", "experiment", "spectator", "helper", "admin"};
            boolean hasIgnoreGroup = false;
            Bukkit.getLogger().info("[Guests] Checking ignore groups for: " + player.getName());
            for (String group : ignoreGroups) {
                if (!player.hasPermission("group." + group)) continue;
                Bukkit.getLogger().info("[Guests] " + player.getName() + " has ignore group: " + group);
                hasIgnoreGroup = true;
                break;
            }
            if (!hasIgnoreGroup) {
                Bukkit.getLogger().info("[Guests] Non-guest does not have ignore group. Setting survival mode for: " + player.getName());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.setGameMode(GameMode.SURVIVAL), 1L);
            }
        }
    }
}

