# --- WEIGHT ASSIGNMENT LOGIC ---
# This function runs on every item entity that does NOT have the 'weight_checked' tag.

# --- 1. Set a default weight (Neutral) for all new items (Weight: 100) ---
# Items not explicitly caught by the rules below (e.g., Dirt, Gravel, most generic blocks) fall here.
scoreboard players set @e[type=item,tag=!weight_checked] item_weight 100

# =========================================================================
# --- 2. TIER 1: AIRY ITEMS (Weight: 25) - Strong Float 🌬️
# Covers soft materials, organic matter, and lightweight components.
# =========================================================================

# Organic and Very Light Materials
execute as @e[type=item,nbt={Item:{id:/\w*feather/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*string/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*wool/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*carpet/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*leaves/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*plant/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*flower/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*vine/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*sapling/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*seed/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*dye/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*sugar/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*paper/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*scute/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*spawn_egg/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*banner/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*map/}},tag=!weight_checked] run scoreboard players set @s item_weight 25
execute as @e[type=item,nbt={Item:{id:/\w*painting/}},tag=!weight_checked] run scoreboard players set @s item_weight 25


# =========================================================================
# --- 3. TIER 2: LIGHT ITEMS (Weight: 75) - Weak Float 🛶
# Covers all wood products, most food, basic tools, and empty/glass containers.
# =========================================================================

# All Wood Products
execute as @e[type=item,nbt={Item:{id:/\w*_planks/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*_log/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*_wood/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*slab/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*stairs/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*fence/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*door/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*trapdoor/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*_boat/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*_raft/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*sign/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*note_block/}},tag=!weight_checked] run scoreboard players set @s item_weight 75

# Food, Bone, Glass, Pottery
execute as @e[type=item,nbt={Item:{id:/\w*stew/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*bread/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*pie/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*cake/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*bottle/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*glass/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*terracotta/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*pot/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*bone/}},tag=!weight_checked] run scoreboard players set @s item_weight 75
execute as @e[type=item,nbt={Item:{id:/\w*stick/}},tag=!weight_checked] run scoreboard players set @s item_weight 75


# =========================================================================
# --- 4. TIER 4: HEAVY ITEMS (Weight: 200) - Weak Sink ⚓
# Covers all metals, ores, dense stone, and heavy functional blocks/tools.
# =========================================================================

# Ores, Ingots, Gems, and Fragments (The material itself)
execute as @e[type=item,nbt={Item:{id:/\w*ore/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*gem/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*ingot/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*fragment/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*nugget/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*raw/}},tag=!weight_checked] run scoreboard players set @s item_weight 200

# Blocks of Metal, Stone, and dense materials (The finished product)
execute as @e[type=item,nbt={Item:{id:/\w*_block/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*brick/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*deepslate/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*tuff/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*obsidian/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*concrete/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*chain/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*bars/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*piston/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*cauldron/}},tag=!weight_checked] run scoreboard players set @s item_weight 200

# Tools, Weapons, and Armor (everything not netherite/heavy core)
execute as @e[type=item,nbt={Item:{id:/\w*sword/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*pickaxe/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*axe/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*shovel/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*hoe/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*helmet/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*plate/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*leggings/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*boots/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*mace/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*spear/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*shield/}},tag=!weight_checked] run scoreboard players set @s item_weight 200
execute as @e[type=item,nbt={Item:{id:/\w*bucket/}},tag=!weight_checked] run scoreboard players set @s item_weight 200


# =========================================================================
# --- 5. TIER 5: VERY HEAVY ITEMS (Weight: 500) - Strong Sink 🪨
# The densest, rarest, and filled/heavy blocks.
# =========================================================================

# Netherite and other extremely dense materials
execute as @e[type=item,nbt={Item:{id:/\w*netherite/}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:"minecraft:ancient_debris"}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:"minecraft:heavy_core"}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:/\w*anvil/}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:/\w*shulker_box/}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:/\w*lodestone/}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:/\w*beacon/}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:/\w*command_block/}},tag=!weight_checked] run scoreboard players set @s item_weight 500
execute as @e[type=item,nbt={Item:{id:/\w*dragon_egg/}},tag=!weight_checked] run scoreboard players set @s item_weight 500


# =========================================================================
# --- 6. Final Tagging ---
# =========================================================================

# Tag the item so it's not checked again next tick (optimizing performance)
tag @e[type=item,tag=!weight_checked] add weight_checked