package net.coolspa.rubyradiance.datagen;





import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2246;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import net.coolspa.rubyradiance.block.ModBlocks;
import net.coolspa.rubyradiance.item.ModItems;
import java.util.concurrent.CompletableFuture;

public class ModRecipeProvider extends FabricRecipeProvider {
    public ModRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    public void method_10419(class_8790 exporter) {
        generateModRecipes(exporter);
        generateBlockRecipes(exporter);
        generateSmeltingRecipes(exporter);
        generateAlternativeRecipes(exporter);
        generatePracticeRecipes(exporter);
        generateConversionRecipes(exporter);
        generateDecorationRecipes(exporter);
        generateUtilityRecipes(exporter);
    }
    
    private void generateModRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40642, ModItems.RUBY_APPLE)
                .method_10439("RRR")
                .method_10439("RAR")
                .method_10439("RRR")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8279)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
        
        class_2447.method_10437(class_7800.field_40642, ModItems.RUBY_WAND)
                .method_10439(" ED")
                .method_10439(" SE")
                .method_10439("S  ")
                .method_10434('S', class_1802.field_8600)
                .method_10434('E', class_1802.field_8687)
                .method_10434('D', class_1802.field_8477)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
    }
    
    private void generateToolRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40638, ModItems.RUBY_PICKAXE)
                .method_10439("RRR")
                .method_10439(" A ")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
        
        class_2447.method_10437(class_7800.field_40638, ModItems.RUBY_AXE)
                .method_10439(" RR")
                .method_10439(" AR")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
        
        class_2447.method_10437(class_7800.field_40639, ModItems.RUBY_SWORD)
                .method_10439(" R ")
                .method_10439(" R ")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
        
        class_2447.method_10437(class_7800.field_40638, ModItems.RUBY_SHOVEL)
                .method_10439(" R ")
                .method_10439(" A ")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
        
        class_2447.method_10437(class_7800.field_40638, ModItems.RUBY_HOE)
                .method_10439(" RR")
                .method_10439(" A ")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
    }
    
    private void generateBlockRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40634, ModBlocks.ETHERNAL_RUBY_BLOCK)
                .method_10439("RRR")
                .method_10439("RRR")
                .method_10439("RRR")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
        
        class_2450.method_10448(class_7800.field_40642, ModItems.ETHERNAL_RUBY, 9)
                .method_10454(ModBlocks.ETHERNAL_RUBY_BLOCK)
                .method_10442(method_32807(ModBlocks.ETHERNAL_RUBY_BLOCK), method_10426(ModBlocks.ETHERNAL_RUBY_BLOCK))
                .method_36443(exporter, "ethernal_emerald_from_block");
        
        class_2447.method_10437(class_7800.field_40636, ModBlocks.MAGIC_BLOCK)
                .method_10439("OEO")
                .method_10439("ERE")
                .method_10439("OEO")
                .method_10434('E', ModItems.ETHERNAL_RUBY)
                .method_10434('R', class_1802.field_8725)
                .method_10434('O', class_2246.field_10540)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_10431(exporter);
    }
    
    private void generateSmeltingRecipes(class_8790 exporter) {
        class_2454.method_17802(
                class_1856.method_8091(class_1802.field_8687),
                class_7800.field_40642,
                ModItems.ETHERNAL_RUBY,
                0.7f,
                200)
                .method_10469(method_32807(class_1802.field_8687), method_10426(class_1802.field_8687))
                .method_36443(exporter, "ethernal_emerald_from_smelting");
        
        class_2454.method_10473(
                class_1856.method_8091(class_1802.field_8687),
                class_7800.field_40642,
                ModItems.ETHERNAL_RUBY,
                0.7f,
                100)
                .method_10469(method_32807(class_1802.field_8687), method_10426(class_1802.field_8687))
                .method_36443(exporter, "ethernal_emerald_from_blasting");
        
        class_2454.method_17802(
                class_1856.method_8091(class_1802.field_8620),
                class_7800.field_40642,
                class_1802.field_8695,
                0.5f,
                200)
                .method_10469(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_36443(exporter, "gold_from_iron_smelting");
        
        class_2454.method_10473(
                class_1856.method_8091(class_1802.field_27022),
                class_7800.field_40642,
                class_1802.field_8620,
                0.5f,
                100)
                .method_10469(method_32807(class_1802.field_27022), method_10426(class_1802.field_27022))
                .method_36443(exporter, "iron_from_copper_blasting");
    }
    
    private void generateAlternativeRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40638, ModItems.RUBY_AXE)
                .method_10439("RR ")
                .method_10439("RA ")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_36443(exporter, "emerald_axe_alt");
        
        class_2447.method_10437(class_7800.field_40638, ModItems.RUBY_HOE)
                .method_10439("RR ")
                .method_10439(" A ")
                .method_10439(" A ")
                .method_10434('R', ModItems.ETHERNAL_RUBY)
                .method_10434('A', class_1802.field_8600)
                .method_10429(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_36443(exporter, "emerald_hoe_alt");
        
        class_2450.method_10447(class_7800.field_40640, ModItems.RUBY_APPLE)
                .method_10454(class_1802.field_8279)
                .method_10454(ModItems.ETHERNAL_RUBY)
                .method_10454(ModItems.ETHERNAL_RUBY)
                .method_10454(ModItems.ETHERNAL_RUBY)
                .method_10454(ModItems.ETHERNAL_RUBY)
                .method_10442(method_32807(ModItems.ETHERNAL_RUBY), method_10426(ModItems.ETHERNAL_RUBY))
                .method_36443(exporter, "emerald_apple_simple");
    }
    
    private void generatePracticeRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40634, class_2246.field_10201)
                .method_10439("DDD")
                .method_10439("DDD")
                .method_10439("DDD")
                .method_10434('D', class_1802.field_8477)
                .method_10429(method_32807(class_1802.field_8477), method_10426(class_1802.field_8477))
                .method_36443(exporter, "diamond_block_practice");
        
        class_2450.method_10448(class_7800.field_40642, class_1802.field_8477, 9)
                .method_10454(class_2246.field_10201)
                .method_10442(method_32807(class_2246.field_10201), method_10426(class_2246.field_10201))
                .method_36443(exporter, "diamond_from_block_practice");
        
        class_2447.method_10437(class_7800.field_40634, class_2246.field_10234)
                .method_10439("EEE")
                .method_10439("EEE")
                .method_10439("EEE")
                .method_10434('E', class_1802.field_8687)
                .method_10429(method_32807(class_1802.field_8687), method_10426(class_1802.field_8687))
                .method_36443(exporter, "emerald_block_practice");
        
        class_2450.method_10448(class_7800.field_40642, class_1802.field_8687, 9)
                .method_10454(class_2246.field_10234)
                .method_10442(method_32807(class_2246.field_10234), method_10426(class_2246.field_10234))
                .method_36443(exporter, "emerald_from_block_practice");
        
        class_2447.method_10437(class_7800.field_40634, class_2246.field_10205)
                .method_10439("GGG")
                .method_10439("GGG")
                .method_10439("GGG")
                .method_10434('G', class_1802.field_8695)
                .method_10429(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                .method_36443(exporter, "gold_block_practice");
        
        class_2450.method_10448(class_7800.field_40642, class_1802.field_8695, 9)
                .method_10454(class_2246.field_10205)
                .method_10442(method_32807(class_2246.field_10205), method_10426(class_2246.field_10205))
                .method_36443(exporter, "gold_from_block_practice");
    }
    
    private void generateConversionRecipes(class_8790 exporter) {
        class_2450.method_10448(class_7800.field_40642, class_1802.field_8713, 4)
                .method_10454(class_2246.field_10381)
                .method_10442(method_32807(class_2246.field_10381), method_10426(class_2246.field_10381))
                .method_36443(exporter, "coal_from_block_conversion");
        
        class_2447.method_10437(class_7800.field_40634, class_2246.field_10381)
                .method_10439("CC")
                .method_10439("CC")
                .method_10434('C', class_1802.field_8713)
                .method_10429(method_32807(class_1802.field_8713), method_10426(class_1802.field_8713))
                .method_36443(exporter, "coal_block_conversion");
        
        class_2450.method_10448(class_7800.field_40642, class_1802.field_8725, 4)
                .method_10454(class_2246.field_10002)
                .method_10442(method_32807(class_2246.field_10002), method_10426(class_2246.field_10002))
                .method_36443(exporter, "redstone_from_block_conversion");
        
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10002)
                .method_10439("RRR")
                .method_10439("RRR")
                .method_10439("RRR")
                .method_10434('R', class_1802.field_8725)
                .method_10429(method_32807(class_1802.field_8725), method_10426(class_1802.field_8725))
                .method_36443(exporter, "redstone_block_conversion");
        
        class_2450.method_10448(class_7800.field_40642, class_1802.field_8759, 9)
                .method_10454(class_2246.field_10441)
                .method_10442(method_32807(class_2246.field_10441), method_10426(class_2246.field_10441))
                .method_36443(exporter, "lapis_from_block_conversion");
        
        class_2447.method_10437(class_7800.field_40634, class_2246.field_10441)
                .method_10439("LLL")
                .method_10439("LLL")
                .method_10439("LLL")
                .method_10434('L', class_1802.field_8759)
                .method_10429(method_32807(class_1802.field_8759), method_10426(class_1802.field_8759))
                .method_36443(exporter, "lapis_block_conversion");
    }
    
    private void generateDecorationRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40635, class_2246.field_10552)
                .method_10439("S")
                .method_10439("S")
                .method_10434('S', class_2246.field_10131)
                .method_10429(method_32807(class_2246.field_10131), method_10426(class_2246.field_10131))
                .method_36443(exporter, "chiseled_stone_bricks_decoration");
        
        class_2447.method_10436(class_7800.field_40635, class_2246.field_10065, 4)
                .method_10439("SS")
                .method_10439("SS")
                .method_10434('S', class_2246.field_10056)
                .method_10429(method_32807(class_2246.field_10056), method_10426(class_2246.field_10056))
                .method_36443(exporter, "mossy_stone_bricks_decoration");
        
        class_2447.method_10436(class_7800.field_40635, class_2246.field_10416, 2)
                .method_10439("S")
                .method_10439("S")
                .method_10434('S', class_2246.field_10056)
                .method_10429(method_32807(class_2246.field_10056), method_10426(class_2246.field_10056))
                .method_36443(exporter, "cracked_stone_bricks_decoration");
        
        class_2447.method_10436(class_7800.field_40635, class_2246.field_10289, 4)
                .method_10439("GG")
                .method_10439("GG")
                .method_10434('G', class_2246.field_10474)
                .method_10429(method_32807(class_2246.field_10474), method_10426(class_2246.field_10474))
                .method_36443(exporter, "polished_granite_decoration");
        
        class_2447.method_10436(class_7800.field_40635, class_2246.field_10346, 4)
                .method_10439("DD")
                .method_10439("DD")
                .method_10434('D', class_2246.field_10508)
                .method_10429(method_32807(class_2246.field_10508), method_10426(class_2246.field_10508))
                .method_36443(exporter, "polished_diorite_decoration");
        
        class_2447.method_10436(class_7800.field_40635, class_2246.field_10093, 4)
                .method_10439("AA")
                .method_10439("AA")
                .method_10434('A', class_2246.field_10115)
                .method_10429(method_32807(class_2246.field_10115), method_10426(class_2246.field_10115))
                .method_36443(exporter, "polished_andesite_decoration");
    }
    
    private void generateUtilityRecipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10282)
                .method_10439("CCC")
                .method_10439("RRQ")
                .method_10439("CCC")
                .method_10434('C', class_2246.field_10445)
                .method_10434('R', class_1802.field_8725)
                .method_10434('Q', class_1802.field_8155)
                .method_10429(method_32807(class_1802.field_8725), method_10426(class_1802.field_8725))
                .method_36443(exporter, "observer_utility");
        
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10560)
                .method_10439("PPP")
                .method_10439("CIC")
                .method_10439("CRC")
                .method_10434('P', class_2246.field_10161)
                .method_10434('C', class_2246.field_10445)
                .method_10434('I', class_1802.field_8620)
                .method_10434('R', class_1802.field_8725)
                .method_10429(method_32807(class_1802.field_8725), method_10426(class_1802.field_8725))
                .method_36443(exporter, "piston_utility");
        
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10615)
                .method_10439("S")
                .method_10439("P")
                .method_10434('S', class_1802.field_8777)
                .method_10434('P', class_2246.field_10560)
                .method_10429(method_32807(class_2246.field_10560), method_10426(class_2246.field_10560))
                .method_36443(exporter, "sticky_piston_utility");
        
        class_2447.method_10437(class_7800.field_40638, class_2246.field_9980)
                .method_10439("PP")
                .method_10439("PP")
                .method_10434('P', class_2246.field_10161)
                .method_10429(method_32807(class_2246.field_10161), method_10426(class_2246.field_10161))
                .method_36443(exporter, "crafting_table_utility");
        
        class_2447.method_10437(class_7800.field_40635, class_2246.field_10181)
                .method_10439("CCC")
                .method_10439("C C")
                .method_10439("CCC")
                .method_10434('C', class_2246.field_10445)
                .method_10429(method_32807(class_2246.field_10445), method_10426(class_2246.field_10445))
                .method_36443(exporter, "furnace_utility");
        
        class_2447.method_10437(class_7800.field_40635, class_2246.field_10034)
                .method_10439("PPP")
                .method_10439("P P")
                .method_10439("PPP")
                .method_10434('P', class_2246.field_10161)
                .method_10429(method_32807(class_2246.field_10161), method_10426(class_2246.field_10161))
                .method_36443(exporter, "chest_utility");
    }
}


