/*
 * Decompiled with CFR 0.152.
 */
package com.shregoo.oneblockchallenges;

import com.shregoo.oneblockchallenges.Challenge;
import com.shregoo.oneblockchallenges.ChallengeManager;
import com.shregoo.oneblockchallenges.OneBlockChallenges;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChallengeCommand
implements CommandExecutor {
    private final OneBlockChallenges plugin;
    private final ChallengeManager manager;

    public ChallengeCommand(OneBlockChallenges plugin, ChallengeManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "OneBlockChallenges commands: /challenge start | progress | status | reload");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "start": {
                Challenge c = this.manager.getCurrentChallenge();
                if (c == null) {
                    sender.sendMessage("No active challenge.");
                    return true;
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    p.sendTitle("\u00a7eNew Challenge Started", "\u00a76" + c.getName(), 10, 100, 10);
                    p.sendMessage("\u00a7a" + c.getDescription());
                } else {
                    sender.sendMessage("Started: " + c.getName());
                }
                return true;
            }
            case "progress": {
                Map<String, Object> summary = this.manager.getSummary();
                sender.sendMessage("\u00a76Phase: \u00a7e" + String.valueOf(summary.get("phase")));
                sender.sendMessage("\u00a76Current: \u00a7e" + String.valueOf(summary.get("current")));
                sender.sendMessage("\u00a76Completed: \u00a7e" + String.valueOf(summary.get("completed")));
                sender.sendMessage("\u00a76Trees grown: \u00a7e" + String.valueOf(summary.get("trees")));
                sender.sendMessage("\u00a76Unique blocks: \u00a7e" + String.valueOf(summary.get("uniqueBlocks")));
                sender.sendMessage("\u00a76Animals: \u00a7e" + String.valueOf(summary.get("animals")));
                return true;
            }
            case "status": {
                sender.sendMessage("OneBlockChallenges running.");
                return true;
            }
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage("Config reloaded.");
                return true;
            }
        }
        sender.sendMessage("Unknown subcommand.");
        return true;
    }
}

