/*
 * Decompiled with CFR 0.152.
 */
package com.shregoo.oneblockchallenges;

import com.shregoo.oneblockchallenges.ChallengeManager;
import com.shregoo.oneblockchallenges.OneBlockChallenges;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;

public class ChallengeListener
implements Listener {
    private final OneBlockChallenges plugin;
    private final ChallengeManager manager;

    public ChallengeListener(OneBlockChallenges plugin, ChallengeManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        e.getPlayer().sendMessage("\u00a76Shregoo kya haal chal dm hai? \u00a7rComplete these challenges to show off!");
        e.getPlayer().sendTitle("\u00a7aWelcome to OneBlock Challenges", "\u00a7e" + this.manager.getPhaseTitle(), 10, 100, 10);
        this.manager.getSummary();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
    }

    @EventHandler
    public void onTreeGrow(StructureGrowEvent e) {
        int logs = 0;
        for (BlockState s : e.getBlocks()) {
            if (!s.getType().name().contains("LOG")) continue;
            ++logs;
        }
        if (logs > 0) {
            this.manager.onSaplingGrow(1);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        this.manager.onBlockMined(b.getType());
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (e.getEntityType() == EntityType.COW || e.getEntityType() == EntityType.SHEEP || e.getEntityType() == EntityType.CHICKEN || e.getEntityType() == EntityType.PIG) {
            this.manager.onAnimalSpawned();
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent e) {
        this.manager.onMobDrop(e.getEntityType().name(), e.getDrops().toArray(new ItemStack[0]));
    }
}

