/*
 * Decompiled with CFR 0.152.
 */
package com.shregoo.oneblockchallenges;

import com.shregoo.oneblockchallenges.Challenge;
import com.shregoo.oneblockchallenges.OneBlockChallenges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChallengeManager {
    private final OneBlockChallenges plugin;
    private final FileConfiguration data;
    private int treeCount = 0;
    private final Set<String> uniqueBlocks = new HashSet<String>();
    private int animalsCount = 0;
    private BossBar bossBar;
    private final List<Challenge> beginnerChallenges = new ArrayList<Challenge>();
    private final List<Challenge> intermediateChallenges = new ArrayList<Challenge>();
    private final List<Challenge> hardcoreChallenges = new ArrayList<Challenge>();

    public ChallengeManager(OneBlockChallenges plugin, FileConfiguration data) {
        this.plugin = plugin;
        this.data = data;
        this.setupChallenges();
        this.setupBossBar();
    }

    private void setupBossBar() {
        this.bossBar = Bukkit.createBossBar((String)"OneBlock Challenges Progress", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[]{BarFlag.CREATE_FOG});
        this.bossBar.setVisible(true);
        this.bossBar.setProgress(0.0);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.bossBar.addPlayer(p);
        }
    }

    private void setupChallenges() {
        this.beginnerChallenges.add(new Challenge("Grow 10 Trees", "Grow 10 saplings into trees.", 100));
        this.beginnerChallenges.add(new Challenge("Block Collector", "Collect 10 unique blocks.", 200));
        this.beginnerChallenges.add(new Challenge("Safe Base", "Create a 10x10 area with light level >=8 and no nearby hostile mobs.", 300));
        this.intermediateChallenges.add(new Challenge("Nether Portal", "Open a nether portal and retrieve 3 unique nether items.", 500));
        this.intermediateChallenges.add(new Challenge("Villager Trading", "Establish villagers and complete 5 trades.", 700));
        this.hardcoreChallenges.add(new Challenge("Ender Dragon", "Defeat the Ender Dragon.", 1000));
        if (!this.data.contains("progress")) {
            this.data.set("progress.trees", (Object)0);
            this.data.set("progress.uniqueBlocks", new ArrayList());
            this.data.set("progress.animals", (Object)0);
            this.plugin.saveDataFile();
        } else {
            this.treeCount = this.data.getInt("progress.trees", 0);
            List blocks = this.data.getStringList("progress.uniqueBlocks");
            this.uniqueBlocks.addAll(blocks);
            this.animalsCount = this.data.getInt("progress.animals", 0);
        }
    }

    public void periodicChecks() {
        int phase = this.data.getInt("currentPhase", 1);
        int idx = this.data.getInt("currentChallengeIndex", 0);
        Challenge current = this.getCurrentChallenge();
        if (current == null) {
            return;
        }
        if (current.getName().equals("Safe Base")) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.checkSafeBaseAt(p.getLocation())) continue;
                this.markComplete(current);
                this.broadcastComplete(current);
                break;
            }
        }
    }

    private boolean checkSafeBaseAt(Location center) {
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Location l = center.clone().add((double)x, 0.0, (double)z);
                byte light = l.getBlock().getLightLevel();
                if (light >= 8) continue;
                return false;
            }
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            for (Entity e : p.getNearbyEntities(16.0, 16.0, 16.0)) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)e;
                switch (le.getType().name()) {
                    case "ZOMBIE": 
                    case "SKELETON": 
                    case "CREEPER": 
                    case "SPIDER": 
                    case "PILLAGER": {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void onSaplingGrow(int amount) {
        this.treeCount += amount;
        this.data.set("progress.trees", (Object)this.treeCount);
        this.plugin.saveDataFile();
        this.updateBossBar();
        this.checkAutoCompleteByName("Grow 10 Trees");
    }

    public void onBlockMined(Material mat) {
        this.uniqueBlocks.add(mat.name());
        this.data.set("progress.uniqueBlocks", new ArrayList<String>(this.uniqueBlocks));
        this.plugin.saveDataFile();
        this.updateBossBar();
        this.checkAutoCompleteByName("Block Collector");
    }

    public void onAnimalSpawned() {
        ++this.animalsCount;
        this.data.set("progress.animals", (Object)this.animalsCount);
        this.plugin.saveDataFile();
        this.updateBossBar();
        this.checkAutoCompleteByName("Animal Island");
    }

    public void onMobDrop(String mobName, ItemStack[] drops) {
        this.checkAutoCompleteByName("Monster Hunter");
    }

    private void checkAutoCompleteByName(String name) {
        Challenge current = this.getCurrentChallenge();
        if (current != null && current.getName().equals(name)) {
            if (name.equals("Grow 10 Trees") && this.treeCount >= 10) {
                this.markComplete(current);
                this.broadcastComplete(current);
            } else if (name.equals("Block Collector") && this.uniqueBlocks.size() >= 10) {
                this.markComplete(current);
                this.broadcastComplete(current);
            }
        }
    }

    private void broadcastComplete(Challenge challenge) {
        Bukkit.getServer().broadcastMessage("[OneBlockChallenges] Challenge complete: " + challenge.getName());
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            p.sendTitle("\u00a7aChallenge Complete!", "\u00a7e" + challenge.getName(), 10, 60, 10);
        }
    }

    private void markComplete(Challenge challenge) {
        List completed = this.data.getStringList("completed");
        if (!completed.contains(challenge.getName())) {
            completed.add(challenge.getName());
            this.data.set("completed", (Object)completed);
            int idx = this.data.getInt("currentChallengeIndex", 0) + 1;
            List<Challenge> currentList = this.getPhaseList(this.data.getInt("currentPhase", 1));
            if (idx >= currentList.size()) {
                int phase = this.data.getInt("currentPhase", 1) + 1;
                this.data.set("currentPhase", (Object)Math.min(3, phase));
                this.data.set("currentChallengeIndex", (Object)0);
            } else {
                this.data.set("currentChallengeIndex", (Object)idx);
            }
            this.plugin.saveDataFile();
            this.updateBossBar();
        }
    }

    private List<Challenge> getPhaseList(int phase) {
        switch (phase) {
            case 1: {
                return this.beginnerChallenges;
            }
            case 2: {
                return this.intermediateChallenges;
            }
            case 3: {
                return this.hardcoreChallenges;
            }
        }
        return this.beginnerChallenges;
    }

    public Challenge getCurrentChallenge() {
        int phase = this.data.getInt("currentPhase", 1);
        int idx = this.data.getInt("currentChallengeIndex", 0);
        List<Challenge> list = this.getPhaseList(phase);
        if (idx < 0 || idx >= list.size()) {
            return null;
        }
        return list.get(idx);
    }

    public String getPhaseTitle() {
        int phase = this.data.getInt("currentPhase", 1);
        switch (phase) {
            case 1: {
                return "\ud83c\udf31 Beginner Challenges";
            }
            case 2: {
                return "\ud83d\udd25 Intermediate Challenges";
            }
            case 3: {
                return "\ud83d\udc80 Hardcore Challenges";
            }
        }
        return "\ud83c\udf31 Beginner Challenges";
    }

    private void updateBossBar() {
        int completedCount = this.data.getStringList("completed").size();
        int total = this.beginnerChallenges.size() + this.intermediateChallenges.size() + this.hardcoreChallenges.size();
        double prog = (double)completedCount / (double)total;
        this.bossBar.setProgress(Math.min(1.0, Math.max(0.0, prog)));
        this.bossBar.setTitle(this.getPhaseTitle() + " \u2014 " + (int)(prog * 100.0) + "% Completed");
    }

    public Map<String, Object> getSummary() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("phase", this.data.getInt("currentPhase", 1));
        Challenge c = this.getCurrentChallenge();
        m.put("current", c == null ? "None" : c.getName());
        m.put("completed", this.data.getStringList("completed"));
        m.put("trees", this.treeCount);
        m.put("uniqueBlocks", this.uniqueBlocks.size());
        m.put("animals", this.animalsCount);
        return m;
    }
}

