/*
 * Decompiled with CFR 0.152.
 */
package com.shregoo.oneblockchallenges;

import com.shregoo.oneblockchallenges.ChallengeCommand;
import com.shregoo.oneblockchallenges.ChallengeListener;
import com.shregoo.oneblockchallenges.ChallengeManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OneBlockChallenges
extends JavaPlugin {
    private File dataFile;
    private FileConfiguration data;
    private ChallengeManager challengeManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadDataFile();
        this.challengeManager = new ChallengeManager(this, this.data);
        this.getServer().getPluginManager().registerEvents((Listener)new ChallengeListener(this, this.challengeManager), (Plugin)this);
        this.getServer().getPluginCommand("challenge").setExecutor((CommandExecutor)new ChallengeCommand(this, this.challengeManager));
        new BukkitRunnable(){

            public void run() {
                OneBlockChallenges.this.challengeManager.periodicChecks();
            }
        }.runTaskTimer((Plugin)this, 100L, 100L);
        this.getLogger().info("OneBlockChallenges enabled.");
    }

    public void onDisable() {
        this.saveDataFile();
        this.getLogger().info("OneBlockChallenges disabled.");
    }

    private void loadDataFile() {
        this.dataFile = new File(this.getDataFolder(), "challenges.yml");
        if (!this.dataFile.exists()) {
            this.dataFile.getParentFile().mkdirs();
            this.saveResource("challenges.yml", false);
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (!this.data.contains("currentPhase")) {
            this.data.set("currentPhase", (Object)1);
        }
        if (!this.data.contains("currentChallengeIndex")) {
            this.data.set("currentChallengeIndex", (Object)0);
        }
        if (!this.data.contains("completed")) {
            this.data.set("completed", null);
        }
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveDataFile() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getData() {
        return this.data;
    }
}

