/*
 * Decompiled with CFR 0.152.
 */
package fr.liveweeeb.commands;

import fr.liveweeeb.Nocila;
import fr.liveweeeb.managers.ConfigManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class delfireCommand
implements CommandExecutor {
    private final Nocila plugin;

    public delfireCommand(Nocila plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players");
            return true;
        }
        Player player = (Player)sender;
        int defaultRadius = (Integer)ConfigManager.getConfigValue("fire.default-radius", 10);
        int maxRadius = (Integer)ConfigManager.getConfigValue("fire.max-radius", 50);
        int radius = defaultRadius;
        if (args.length > 0) {
            try {
                radius = Integer.parseInt(args[0]);
                if (radius < 1) {
                    radius = 1;
                }
                if (radius > maxRadius) {
                    player.sendMessage(this.plugin.getPrefix() + " \u00a7cRadius cannot exceed " + maxRadius + " blocks!");
                    radius = maxRadius;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.plugin.getPrefix() + " \u00a7cInvalid radius! Using default " + defaultRadius + " blocks.");
                radius = defaultRadius;
            }
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        int fireRemoved = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Location blockLoc = playerLoc.clone().add((double)x, (double)y, (double)z);
                    if (world.getBlockAt(blockLoc).getType() != Material.FIRE) continue;
                    world.getBlockAt(blockLoc).setType(Material.AIR);
                    ++fireRemoved;
                }
            }
        }
        if (fireRemoved > 0) {
            player.sendMessage(this.plugin.getPrefix() + " \u00a7aRemoved \u00a7e" + fireRemoved + " \u00a7afire blocks within \u00a76" + radius + " \u00a7ablocks!");
        } else {
            player.sendMessage(this.plugin.getPrefix() + " \u00a77No fire found within \u00a76" + radius + " \u00a77blocks.");
        }
        return true;
    }
}

