/*
 * Decompiled with CFR 0.152.
 */
package fr.liveweeeb.commands;

import fr.liveweeeb.Nocila;
import fr.liveweeeb.managers.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class killallCommand
implements CommandExecutor {
    private final Nocila plugin;
    private final List<String> noKillEntities;

    public killallCommand(Nocila plugin) {
        this.plugin = plugin;
        this.noKillEntities = new ArrayList<String>();
        this.loadNoKillEntities();
    }

    private void loadNoKillEntities() {
        this.noKillEntities.clear();
        List configList = (List)ConfigManager.getConfigValue("killall.nokill", List.of());
        for (String entityName : configList) {
            this.noKillEntities.add(entityName.toUpperCase());
        }
        if (this.noKillEntities.isEmpty()) {
            this.noKillEntities.add("ZOMBIE");
            this.noKillEntities.add("VILLAGER");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        List entities;
        World world;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by a player");
            return true;
        }
        this.loadNoKillEntities();
        if (!sender.hasPermission("minecraft.kill") && !sender.hasPermission("nocila.killall")) {
            sender.sendMessage(this.plugin.getPrefix() + " \u00a7cYou don't have permission to use this command!");
            return true;
        }
        int radius = -1;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            world = player.getWorld();
            if (args.length > 0) {
                try {
                    radius = Integer.parseInt(args[0]);
                    if (radius < 1) {
                        sender.sendMessage(this.plugin.getPrefix() + " \u00a7cRadius must be at least 1!");
                        return true;
                    }
                    if (radius > 500) {
                        sender.sendMessage(this.plugin.getPrefix() + " \u00a7cRadius cannot exceed 500 blocks!");
                        radius = 500;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getPrefix() + " \u00a7cInvalid radius!.");
                }
            }
        } else {
            world = (World)this.plugin.getServer().getWorlds().get(0);
        }
        int killedEntities = 0;
        int skippedEntities = 0;
        if (radius > 0 && sender instanceof Player) {
            Player player = (Player)sender;
            entities = player.getNearbyEntities((double)radius, (double)radius, (double)radius);
        } else {
            entities = world.getEntities();
        }
        for (Entity entity : entities) {
            if (entity.getType() == EntityType.PLAYER) continue;
            String entityName = entity.getType().name();
            if (this.noKillEntities.contains(entityName)) {
                ++skippedEntities;
                continue;
            }
            entity.remove();
            ++killedEntities;
        }
        String message = this.plugin.getPrefix() + " \u00a7aKilled \u00a7e" + killedEntities + " \u00a7aentities";
        message = radius > 0 ? message + " within \u00a76" + radius + " \u00a7ablocks!" : message + " in the entire world!";
        sender.sendMessage(message);
        if (args.length > 1 && args[1].equalsIgnoreCase("info")) {
            sender.sendMessage("\u00a77Protected entities: \u00a7e" + String.join((CharSequence)", ", this.noKillEntities));
        }
        return true;
    }
}

