/*
 * Decompiled with CFR 0.152.
 */
package fr.liveweeeb.commands;

import fr.liveweeeb.Nocila;
import fr.liveweeeb.managers.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class masssummonCommand
implements CommandExecutor,
TabCompleter {
    private final Nocila plugin;
    private final List<String> vanillaEntities;

    public masssummonCommand(Nocila plugin) {
        this.plugin = plugin;
        this.vanillaEntities = new ArrayList<String>();
        for (EntityType type : EntityType.values()) {
            if (!type.isSpawnable() || !type.isAlive()) continue;
            this.vanillaEntities.add(type.name().toLowerCase());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players");
            return true;
        }
        Player player = (Player)sender;
        int maxAmount = (Integer)ConfigManager.getConfigValue("masssummon.max-amount", 50);
        if (args.length < 2) {
            player.sendMessage(this.plugin.getPrefix() + " \u00a7cUsage: /masssummon <entity> <amount>");
            return true;
        }
        String entityName = args[0];
        try {
            amount = Integer.parseInt(args[1]);
            if (amount < 1) {
                amount = 1;
            }
            if (amount > maxAmount) {
                player.sendMessage(this.plugin.getPrefix() + " \u00a7cMaximum amount " + maxAmount);
                amount = maxAmount;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getPrefix() + " \u00a7cInvalid amount! Use a number between 1-" + maxAmount);
            return true;
        }
        Location spawnLocation = player.getLocation();
        World world = player.getWorld();
        int spawnedCount = 0;
        try {
            EntityType vanillaType = EntityType.valueOf((String)entityName.toUpperCase());
            if (vanillaType.isSpawnable() && vanillaType.isAlive()) {
                for (int i = 0; i < amount; ++i) {
                    world.spawnEntity(spawnLocation, vanillaType);
                    ++spawnedCount;
                }
                player.sendMessage(this.plugin.getPrefix() + " \u00a7aSummoned \u00a7e" + spawnedCount + " \u00a7a" + entityName + "(s)!");
                return true;
            }
        }
        catch (IllegalArgumentException vanillaType) {
            // empty catch block
        }
        try {
            for (int i = 0; i < amount; ++i) {
                String summonCommand = String.format("execute as %s at @s run summon %s ~ ~ ~", player.getName(), entityName);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)summonCommand);
                ++spawnedCount;
            }
            player.sendMessage(this.plugin.getPrefix() + " \u00a7aSummoned \u00a7e" + spawnedCount + " \u00a7a" + entityName + "(s)!");
        }
        catch (Exception ex) {
            player.sendMessage(this.plugin.getPrefix() + " \u00a7cFailed to summon entity: " + entityName);
            player.sendMessage("\u00a77Make sure the entity ID is correct and supported");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        int maxAmountF = (Integer)ConfigManager.getConfigValue("masssummon.max-amount", 50);
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            for (String entity : this.vanillaEntities) {
                if (!entity.startsWith(input)) continue;
                completions.add(entity);
            }
            if (completions.isEmpty()) {
                String[] commonModdedEntities;
                for (String modEntity : commonModdedEntities = new String[]{"minecraft:", "modid:entity_", "twilightforest:", "iceandfire:", "lycanitesmobs:", "mowziesmobs:", "alexsmobs:", "create:"}) {
                    if (!modEntity.startsWith(input)) continue;
                    completions.add(modEntity);
                }
            }
        } else if (args.length == 2) {
            completions.add("1");
            completions.add("5");
            completions.add("10");
            completions.add("20");
            completions.add("50");
            if (maxAmountF > 50) {
                completions.add(String.valueOf(maxAmountF));
            }
        }
        return completions;
    }
}

