/*
 * Decompiled with CFR 0.152.
 */
package fr.liveweeeb.commands;

import fr.liveweeeb.Nocila;
import fr.liveweeeb.managers.ConfigManager;
import fr.liveweeeb.managers.PluginManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class nocilaCommand
implements CommandExecutor,
TabCompleter {
    private final Nocila plugin;

    public nocilaCommand(Nocila plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.plugin.getPrefix() + " \u00a7cUsage: /nocila <arg>");
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            sender.sendMessage("\u00a7eList of available Nocila commands:");
            sender.sendMessage("\u00a76/nocila help \u00a77- View help");
            sender.sendMessage("\u00a76/about \u00a77- About Nocila");
            sender.sendMessage("\u00a76/broadcast \u00a77- Send a message to all players");
            sender.sendMessage("\u00a76/craft \u00a77- Open a Workbench");
            sender.sendMessage("\u00a76/rename <name> \u00a77- Rename the item in your hand");
            sender.sendMessage("\u00a76/hat \u00a77- Wear the item in your hand as a hat");
            sender.sendMessage("\u00a76/day \u00a77- Set the day");
            sender.sendMessage("\u00a76/night \u00a77- Set the night");
            sender.sendMessage("\u00a76/lore <text> \u00a77- Add lore to the item in your hand");
            sender.sendMessage("\u00a76/repair \u00a77- Repair the item in your hand");
            sender.sendMessage("\u00a76/delfire [radius] \u00a77- Remove fire around you");
            sender.sendMessage("\u00a76/smite <player> \u00a77- Strike a player with lightning");
            sender.sendMessage("\u00a76\u00a7o/masssummon <entity> <amount> \u00a77- Spawn the number of entities requested");
            sender.sendMessage("\u00a76\u00a7o/nokill [radius] \u00a77- Kill all non-player entities (except those entered in the config)");
            return true;
        }
        if (args[0].equalsIgnoreCase("debug")) {
            sender.sendMessage("\u00a7eList of available Nocila debug commands:");
            sender.sendMessage("\u00a76/nocila debug-update \u00a77- See if update checking is activated");
            sender.sendMessage("\u00a76/nocila debug-maxsummon \u00a77- See the maximum amount for the /masssummon command");
            sender.sendMessage("\u00a76/nocila debug-nokill \u00a77- See the list of entities that will not be killed via the /killall command");
            return true;
        }
        if (args[0].equalsIgnoreCase("debug-update")) {
            boolean updateEnabled = this.plugin.isUpdateEnabled();
            sender.sendMessage(this.plugin.getPrefix() + " \u00a7c\u00a7lDEBUG: \u00a77" + updateEnabled);
            return true;
        }
        if (args[0].equalsIgnoreCase("debug-maxsummon")) {
            int maxAmount = (Integer)ConfigManager.getConfigValue("masssummon.max-amount", 50);
            sender.sendMessage(this.plugin.getPrefix() + " \u00a7c\u00a7lDEBUG: \u00a77" + maxAmount);
            return true;
        }
        if (args[0].equalsIgnoreCase("debug-nokill")) {
            List configList = (List)ConfigManager.getConfigValue("killall.nokill", List.of());
            sender.sendMessage(this.plugin.getPrefix() + " \u00a7c\u00a7lDEBUG: \u00a77" + String.join((CharSequence)", ", configList));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("nocila.reload")) {
                sender.sendMessage(this.plugin.getPrefix() + " \u00a7cYou don't have permission to reload the config!");
                return true;
            }
            PluginManager.getInstance().getConfigManager().reloadPluginConfig();
            sender.sendMessage(this.plugin.getPrefix() + " \u00a7aConfiguration reloaded successfully!");
            return true;
        }
        sender.sendMessage(this.plugin.getPrefix() + " \u00a7cUnknown subcommand: " + args[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("help");
            completions.add("debug");
            completions.add("reload");
        }
        return completions;
    }
}

