/*
 * Decompiled with CFR 0.152.
 */
package fr.liveweeeb.managers;

import fr.liveweeeb.Nocila;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigManager {
    private final Nocila main;
    private static final Map<String, Object> configCache = new HashMap<String, Object>();
    private String prefix;

    public ConfigManager(Nocila main) {
        this.main = main;
    }

    public void createConfigIfNotExists() {
        File pluginFolder = this.main.getDataFolder();
        File configFile = new File(pluginFolder, "config.yml");
        if (!pluginFolder.exists()) {
            if (pluginFolder.mkdirs()) {
                this.main.getLogger().info("Nocila file successfully created");
            } else {
                this.main.getLogger().warning("Unable to create Nocila folder");
            }
        }
        if (!configFile.exists()) {
            try {
                if (configFile.createNewFile()) {
                    String defaultConfig = "# This is the Nocila configuration file\n# For information go to https://modrinth.com/plugin/nocila\nprefix: \"\u00a73\u00a7l[\u00a79\u00a7lNocila\u00a73\u00a7l]\u00a7r\"\n\nupdate: true\n\n# Fire command settings\nfire:\n  default-radius: 10 # Using a radius larger than 200 may crash your server.\n  max-radius: 50     # Using a radius larger than 200 may crash your server.\n\nmasssummon:\n  max-amount: 50\n\nkillall:\n   nokill:\n         - CAT     # It won't kill the   CAT  when the /killall command will be executed\n         - AXOLOT  # It won't kill the AXOLOT when the /killall command will be executed\n         - WOLF    # It won't kill the  WOLF  when the /killall command will be executed\n\n# Thanks for using Nocila\n";
                    Files.write(configFile.toPath(), defaultConfig.getBytes(), StandardOpenOption.WRITE);
                    this.main.getLogger().info("config.yml file successfully created with default values");
                }
            }
            catch (IOException e) {
                this.main.getLogger().severe("Error creating config.yml file: " + e.getMessage());
            }
        }
    }

    public void loadConfig() {
        Set keys = this.main.getConfig().getKeys(true);
        for (String key : keys) {
            Object value = this.main.getConfig().get(key);
            configCache.put(key, value);
            if (!key.equals("prefix")) continue;
            this.prefix = String.valueOf(value);
        }
    }

    public static Object getConfigValue(String key, Object defaultValue) {
        return configCache.getOrDefault(key, defaultValue);
    }

    public void reloadPluginConfig() {
        this.main.reloadConfig();
        configCache.clear();
        this.loadConfig();
    }

    public String getPrefix() {
        return this.prefix;
    }
}

