/*
 * Decompiled with CFR 0.152.
 */
package fr.liveweeeb.utils;

import fr.liveweeeb.Nocila;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final Plugin plugin;
    private final String url;
    private boolean updateAvailable = false;
    private String currentVersion;
    private final String[] ignoredKeywords = new String[]{"beta", "alpha", "snapshot"};

    public void pls() {
        this.plugin.getLogger().info("Update available: " + this.updateAvailable);
    }

    public UpdateChecker(Plugin plugin, String url) {
        this.plugin = plugin;
        this.url = url;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void check() {
        this.checkAndNotify(false);
    }

    private void checkAndNotify(boolean forJoin) {
        Nocila nocila;
        if (this.plugin instanceof Nocila && !(nocila = (Nocila)this.plugin).isUpdateEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                URL versionUrl = new URL(this.url);
                HttpURLConnection conn = (HttpURLConnection)versionUrl.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String latestVersion = in.readLine().trim();
                in.close();
                if (this.containsIgnoredKeyword(this.currentVersion) || this.containsIgnoredKeyword(latestVersion)) {
                    return;
                }
                if (this.isNewerVersion(latestVersion, this.currentVersion)) {
                    this.updateAvailable = true;
                    String message = "\u00a7c\u26a0 A new version of nocila is available\u00a7r\n\u00a77Current version: \u00a7c" + this.currentVersion + "\n\u00a77New version: \u00a7a" + latestVersion + "\n\u00a79\u00a7nhttps://modrinth.com/plugin/nocila";
                    this.plugin.getLogger().warning(message);
                    Bukkit.getScheduler().runTask(this.plugin, () -> {
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            if (!p.isOp()) continue;
                            p.sendMessage(message);
                        }
                    });
                } else if (!forJoin) {
                    this.updateAvailable = false;
                    this.plugin.getLogger().info("Nocila is up to date !");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Unable to check for updates : " + e.getMessage());
            }
        });
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        this.checkAndNotify(true);
    }

    private boolean containsIgnoredKeyword(String version) {
        version = version.toLowerCase();
        for (String keyword : this.ignoredKeywords) {
            if (!version.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private boolean isNewerVersion(String latest, String current) {
        String[] latestParts = latest.split("\\.");
        String[] currentParts = current.split("\\.");
        int length = Math.max(latestParts.length, currentParts.length);
        for (int i = 0; i < length; ++i) {
            int currentNum;
            int latestNum = i < latestParts.length ? this.parseIntSafe(latestParts[i]) : 0;
            int n = currentNum = i < currentParts.length ? this.parseIntSafe(currentParts[i]) : 0;
            if (latestNum > currentNum) {
                return true;
            }
            if (latestNum >= currentNum) continue;
            return false;
        }
        return false;
    }

    private int parseIntSafe(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

